/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.utils.Uris;
import org.eclipse.swt.widgets.Shell;

public final class Dialogs {
    private static final List<String> SUPPORTED_PROTOCOLS = ImmutableList.of((Object)"file", (Object)"http", (Object)"https");

    private Dialogs() {
    }

    public static InputDialog newModelRepositoryUrlDialog(Shell parent, final String[] remoteUris) {
        return new InputDialog(parent, Messages.DIALOG_TITLE_ADD_MODEL_REPOSITORY, Messages.FIELD_LABEL_REPOSITORY_URI, "http://download.eclipse.org/recommenders/models/<version>", new IInputValidator(){

            public String isValid(String newText) {
                URI uri = (URI)Uris.parseURI((String)newText).orNull();
                if (uri == null) {
                    return Messages.DIALOG_MESSAGE_INVALID_URI;
                }
                if (!uri.isAbsolute()) {
                    return Messages.DIALOG_MESSAGE_NOT_ABSOLUTE_URI;
                }
                if (this.isUriAlreadyAdded(uri)) {
                    return Messages.DIALOG_MESSAGE_URI_ALREADY_ADDED;
                }
                if (!Uris.isUriProtocolSupported((URI)uri, (List)SUPPORTED_PROTOCOLS)) {
                    return MessageFormat.format(Messages.DIALOG_MESSAGE_UNSUPPORTED_PROTOCOL, uri.getScheme(), StringUtils.join((Iterable)SUPPORTED_PROTOCOLS, (String)Messages.LIST_SEPARATOR));
                }
                return null;
            }

            private boolean isUriAlreadyAdded(URI uri) {
                String mangledUri = Uris.mangle((URI)uri);
                String[] stringArray = remoteUris;
                int n = remoteUris.length;
                int n2 = 0;
                while (n2 < n) {
                    String remoteUri = stringArray[n2];
                    if (Uris.mangle((URI)Uris.toUri((String)remoteUri)).equals(mangledUri)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }
}

