/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.names;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class VmFieldName
implements IFieldName {
    private static final long serialVersionUID = 5067244907255465328L;
    private static Map<String, VmFieldName> index = new MapMaker().weakValues().makeMap();
    private String identifier;

    public static synchronized VmFieldName get(ITypeName declaringType, String fieldName, ITypeName fieldType) {
        return VmFieldName.get(String.valueOf(declaringType.getIdentifier()) + "." + fieldName + ";" + fieldType.getIdentifier());
    }

    public static synchronized VmFieldName get(String fieldName) {
        VmFieldName res = index.get(fieldName);
        if (res == null) {
            res = new VmFieldName(fieldName);
            index.put(fieldName, res);
        }
        return res;
    }

    @VisibleForTesting
    protected VmFieldName(String vmFieldName) {
        this.identifier = vmFieldName;
        Checks.ensureIsNotNull(this.identifier);
        Checks.ensureIsNotNull(this.getDeclaringType());
        Checks.ensureIsNotNull(this.getFieldName());
        Checks.ensureIsNotNull(this.getFieldType());
    }

    @Override
    public ITypeName getDeclaringType() {
        String declaringType = StringUtils.substringBeforeLast((String)this.identifier, (String)".");
        return VmTypeName.get(declaringType);
    }

    @Override
    public String getFieldName() {
        return StringUtils.substringBetween((String)this.identifier, (String)".", (String)";");
    }

    @Override
    public ITypeName getFieldType() {
        String fieldType = StringUtils.substringAfter((String)this.identifier, (String)";");
        return VmTypeName.get(fieldType);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int compareTo(IFieldName other) {
        return this.identifier.compareTo(other.getIdentifier());
    }

    public String toString() {
        return this.getIdentifier();
    }
}

