/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ICComboRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class CComboSubModuleController
extends SubModuleController {
    private final PersonManager manager = new PersonManager((Collection)PersonFactory.createPersonList());
    private final PersonModificationBean value = new PersonModificationBean();
    private IComboRidget comboOne;
    private ITextRidget textFirst;
    private ITextRidget textLast;

    public CComboSubModuleController() {
        this(null);
    }

    public CComboSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.comboOne.bindToModel((Object)this.manager, "persons", String.class, null, (Object)this, "selectedPerson");
        this.comboOne.setMandatory(true);
        this.comboOne.updateFromModel();
        this.textFirst.bindToModel((Object)this.value, "firstName");
        this.textFirst.updateFromModel();
        this.textLast.bindToModel((Object)this.value, "lastName");
        this.textLast.updateFromModel();
    }

    public void configureRidgets() {
        this.comboOne = (IComboRidget)this.getRidget(ICComboRidget.class, "comboOne");
        this.value.setPerson(this.manager.getSelectedPerson());
        this.textFirst = (ITextRidget)this.getRidget(ITextRidget.class, "textFirst");
        this.textLast = (ITextRidget)this.getRidget(ITextRidget.class, "textLast");
        this.comboOne.addPropertyChangeListener("selection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Person selectedPerson = (Person)evt.getNewValue();
                CComboSubModuleController.this.value.setPerson(selectedPerson);
                CComboSubModuleController.this.textFirst.updateFromModel();
                CComboSubModuleController.this.textLast.updateFromModel();
            }
        });
        IActionRidget buttonSave = (IActionRidget)this.getRidget(IActionRidget.class, "buttonSave");
        buttonSave.setText("&Save");
        buttonSave.addListener(new IActionListener(){

            public void callback() {
                CComboSubModuleController.this.value.update();
                CComboSubModuleController.this.setSelectedPerson(CComboSubModuleController.this.manager.getPersons().toArray(new Person[0])[5]);
                CComboSubModuleController.this.comboOne.updateFromModel();
            }
        });
        final IToggleButtonRidget buttonSecondValue = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "buttonSecondValue");
        if (buttonSecondValue != null) {
            buttonSecondValue.setText("Always use second person!");
            buttonSecondValue.addListener(new IActionListener(){

                public void callback() {
                    if (buttonSecondValue.isSelected()) {
                        if (CComboSubModuleController.this.manager.getPersons().size() > 1) {
                            Iterator iterator = CComboSubModuleController.this.manager.getPersons().iterator();
                            iterator.next();
                            Person second = (Person)iterator.next();
                            CComboSubModuleController.this.setSelectedPerson(second);
                        }
                        CComboSubModuleController.this.comboOne.setOutputOnly(true);
                    } else {
                        CComboSubModuleController.this.comboOne.setOutputOnly(false);
                    }
                    CComboSubModuleController.this.comboOne.updateFromModel();
                }
            });
        }
        IActionRidget buttonClear = (IActionRidget)this.getRidget(IActionRidget.class, "buttonClear");
        buttonClear.setText("&Clear");
        buttonClear.addListener(new IActionListener(){

            public void callback() {
                CComboSubModuleController.this.comboOne.setSelection(-1);
            }
        });
    }

    public Person getSelectedPerson() {
        return this.manager.getSelectedPerson();
    }

    public void setSelectedPerson(Person selection) {
        Collection persons;
        String lastname;
        this.manager.setSelectedPerson(selection);
        if (selection != null && !StringUtils.isEmpty((CharSequence)(lastname = selection.getLastname())) && lastname.startsWith("JJ") && (persons = this.manager.getPersons()) != null && !persons.isEmpty()) {
            this.manager.setSelectedPerson((Person)persons.iterator().next());
        }
        this.comboOne.updateFromModel();
    }
}

