/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets.frombugs;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.ui.swt.ImageButton;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SnippetMouseUpBug {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        try {
            final Shell shell = new Shell();
            GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 10).spacing(20, 10).applyTo((Composite)shell);
            BtnListener btnListener = new BtnListener();
            Button b1 = new Button((Composite)shell, 8);
            b1.setText("push");
            b1.addMouseListener((MouseListener)btnListener);
            b1.addMouseTrackListener((MouseTrackListener)btnListener);
            b1.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    System.out.println("focusLost() " + SnippetMouseUpBug.getBtnText((TypedEvent)e));
                    SnippetMouseUpBug.showDialog(shell);
                }

                public void focusGained(FocusEvent e) {
                }
            });
            Button b2 = new Button((Composite)shell, 2);
            b2.setText("toggle");
            b2.addMouseListener((MouseListener)btnListener);
            b2.addMouseTrackListener((MouseTrackListener)btnListener);
            ImageButton b3 = new ImageButton((Composite)shell, 0);
            b3.setImage(display.getSystemImage(8));
            b3.setFocusedImage(display.getSystemImage(1));
            b3.setHoverImage(display.getSystemImage(2));
            b3.setPressedImage(display.getSystemImage(4));
            b3.addMouseListener((MouseListener)btnListener);
            b3.addMouseTrackListener((MouseTrackListener)btnListener);
            b1.setFocus();
            shell.setSize(200, 200);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            display.dispose();
        }
    }

    private static void showDialog(Shell parentShell) {
        final Shell dialog = new Shell(parentShell, 67680);
        dialog.setText("Dialog");
        dialog.setSize(120, 100);
        Button buttonOK = new Button((Composite)dialog, 8);
        buttonOK.setText("OK");
        buttonOK.setBounds(25, 20, 80, 25);
        buttonOK.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                dialog.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                dialog.close();
            }
        });
        dialog.open();
    }

    private static String getBtnText(TypedEvent e) {
        if (e.getSource() instanceof Button) {
            return ((Button)e.getSource()).getText();
        }
        if (e.getSource() instanceof ImageButton) {
            return "ImageButton";
        }
        return "?";
    }

    private static class BtnListener
    implements MouseListener,
    MouseTrackListener {
        private BtnListener() {
        }

        public void mouseEnter(MouseEvent e) {
            System.out.println("mouseEnter() " + SnippetMouseUpBug.getBtnText((TypedEvent)e));
        }

        public void mouseExit(MouseEvent e) {
            System.out.println("mouseExit() " + SnippetMouseUpBug.getBtnText((TypedEvent)e));
        }

        public void mouseHover(MouseEvent e) {
            System.out.println("mouseHover() " + SnippetMouseUpBug.getBtnText((TypedEvent)e));
        }

        public void mouseDoubleClick(MouseEvent e) {
            System.out.println("mouseDoubleClick() " + SnippetMouseUpBug.getBtnText((TypedEvent)e));
        }

        public void mouseDown(MouseEvent e) {
            System.out.println("mouseDown() " + SnippetMouseUpBug.getBtnText((TypedEvent)e));
        }

        public void mouseUp(MouseEvent e) {
            System.out.println("mouseUp() " + SnippetMouseUpBug.getBtnText((TypedEvent)e));
        }
    }
}

