/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common;

import java.util.Dictionary;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.RienaPlugin;
import org.eclipse.riena.core.util.ContainerModel;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.security.common.SecurityCallHook;
import org.eclipse.riena.internal.security.common.SentinelServiceImpl;
import org.eclipse.riena.internal.security.common.SimpleSubjectHolder;
import org.eclipse.riena.internal.security.common.SimpleThreadedSubjectHolder;
import org.eclipse.riena.internal.security.common.authorization.PermissionCache;
import org.eclipse.riena.internal.security.common.session.SimpleSessionHolder;
import org.eclipse.riena.internal.security.common.session.SimpleThreadedSessionHolder;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.authorization.IPermissionCache;
import org.eclipse.riena.security.common.authorization.ISentinelService;
import org.eclipse.riena.security.common.session.ISessionHolder;
import org.osgi.framework.BundleContext;

public class Activator
extends RienaPlugin {
    public static final String PLUGIN_ID = "org.eclipse.riena.security.common";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.createSessionHolder();
        this.createSecurityCallHook();
        this.createSubjectHolder();
        this.createPermissionCache();
        this.createSentinelService();
    }

    private void createSessionHolder() {
        this.getContext().registerService(ISessionHolder.class.getName(), (Object)(ContainerModel.isClient() ? new SimpleSessionHolder() : new SimpleThreadedSessionHolder()), null);
    }

    private void createSubjectHolder() {
        this.getContext().registerService(ISubjectHolder.class.getName(), (Object)(ContainerModel.isClient() ? new SimpleSubjectHolder() : new SimpleThreadedSubjectHolder()), null);
    }

    private void createSecurityCallHook() {
        SecurityCallHook hook = new SecurityCallHook();
        Wire.instance((Object)hook).andStart();
        this.getContext().registerService(ICallHook.class.getName(), (Object)hook, null);
    }

    private void createSentinelService() {
        SentinelServiceImpl sentinelService = new SentinelServiceImpl();
        Wire.instance((Object)sentinelService).andStart();
        this.getContext().registerService(ISentinelService.class.getName(), (Object)sentinelService, (Dictionary)RienaConstants.newDefaultServiceProperties());
    }

    private void createPermissionCache() {
        PermissionCache permissionCache = new PermissionCache();
        Wire.instance((Object)permissionCache).andStart();
        this.getContext().registerService(IPermissionCache.class.getName(), (Object)permissionCache, (Dictionary)RienaConstants.newDefaultServiceProperties());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

