/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.uiprocess;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.ui.core.Activator;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitor;
import org.eclipse.riena.ui.core.uiprocess.IUIProcessChangeListener;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.riena.ui.core.uiprocess.ListenerWrapper;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;
import org.eclipse.riena.ui.core.uiprocess.ProgressProviderBridge;
import org.eclipse.riena.ui.core.uiprocess.UICallbackDispatcher;
import org.eclipse.riena.ui.core.uiprocess.UISynchronizer;
import org.osgi.framework.BundleContext;

public class UIProcess
extends PlatformObject
implements IUIMonitor {
    public static final QualifiedName PROPERTY_CONTEXT = new QualifiedName("uiProcess", "context");
    private final UICallbackDispatcher callbackDispatcher;
    private final Job job;
    private final ListenerWrapper listenerWrapper = new ListenerWrapper();

    public UIProcess(String name) {
        this(name, false);
    }

    public UIProcess(String name, boolean user) {
        this(name, user, new Object());
    }

    public UIProcess(String name, boolean user, Object context) {
        this(name, UISynchronizer.createSynchronizer(), user, context);
    }

    public UIProcess(String name, IUISynchronizer syncher, boolean user, Object context) {
        this(name, new UICallbackDispatcher(syncher), user, context);
    }

    private UIProcess(String name, UICallbackDispatcher dispatcher, boolean user, Object context) {
        this.callbackDispatcher = dispatcher;
        this.job = this.createJob(name, user, context);
        this.updateProcessConfiguration();
    }

    public UIProcess(Job job) {
        this.callbackDispatcher = new UICallbackDispatcher(UISynchronizer.createSynchronizer());
        this.job = job;
        this.updateProcessConfiguration();
    }

    private void updateProcessConfiguration() {
        this.configureProcessInfo();
    }

    private void configureProcessInfo() {
        if (this.callbackDispatcher != null) {
            ProcessInfo processInfo = this.callbackDispatcher.getProcessInfo();
            processInfo.setContext(this.job.getProperty(PROPERTY_CONTEXT));
            processInfo.addPropertyChangeListener(new CancelListener());
            processInfo.setDialogVisible(this.job.isUser());
            processInfo.setNote(this.job.getName());
            processInfo.setTitle(this.job.getName());
        }
    }

    private Job createJob(String name, boolean user, Object context) {
        InternalJob newJob = new InternalJob(name);
        newJob.setUser(user);
        newJob.setProperty(PROPERTY_CONTEXT, context);
        return newJob;
    }

    protected boolean forceMonitorBegin() {
        return true;
    }

    public Job getJob() {
        return this.job;
    }

    protected void beforeRun(IProgressMonitor monitor) {
    }

    protected void afterRun(IProgressMonitor monitor) {
    }

    protected int getTotalWork() {
        return -1;
    }

    private void register() {
        this.callbackDispatcher.addUIMonitor(this);
        this.callbackDispatcher.addUIMonitor(this.listenerWrapper);
        ProgressProviderBridge.instance().registerMapping(this.job, this);
    }

    public UICallbackDispatcher getCallbackDispatcher() {
        return this.callbackDispatcher;
    }

    @Override
    public void updateProgress(int progress) {
    }

    @Override
    public void initialUpdateUI(int totalWork) {
    }

    @Override
    public void finalUpdateUI() {
    }

    public boolean runJob(IProgressMonitor monitor) {
        return true;
    }

    public boolean start() {
        int state = this.job.getState();
        if (state == 4 || state == 2 || state == 1) {
            return false;
        }
        this.register();
        this.job.schedule();
        return true;
    }

    public Object getAdapter(Class adapter) {
        Object adapted = super.getAdapter(adapter);
        if (adapted == null) {
            if (adapter.isInstance(this)) {
                adapted = this;
            }
            if (adapter.equals(UICallbackDispatcher.class)) {
                adapted = this.getCallbackDispatcher();
            }
        }
        return adapted;
    }

    public void setNote(String note) {
        this.getProcessInfo().setNote(note);
    }

    public void setTitle(String title) {
        this.getProcessInfo().setTitle(title);
    }

    public void setCancelEnabled(boolean enabled) {
        this.getProcessInfo().setCancelEnabled(enabled);
    }

    public void setCancelVisible(boolean visible) {
        this.getProcessInfo().setCancelVisible(visible);
    }

    public void setIcon(String icon) {
        this.getProcessInfo().setIcon(icon);
    }

    public void setProgresStrategy(ProcessInfo.ProgresStrategy strategy) {
        this.getProcessInfo().setProgresStartegy(strategy);
    }

    private ProcessInfo getProcessInfo() {
        return this.getCallbackDispatcher().getProcessInfo();
    }

    protected void notifyUpdateUI() {
        this.getCallbackDispatcher().getSyncher().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    UIProcess.this.updateUI();
                }
                catch (Exception e) {
                    ((IExceptionHandlerManager)Service.get((BundleContext)Activator.getDefault().getContext(), IExceptionHandlerManager.class)).handleException((Throwable)e);
                }
            }
        });
    }

    @Deprecated
    public void updateUi() {
    }

    protected void updateUI() {
        this.updateUi();
    }

    public void addUIProcessChangedListener(IUIProcessChangeListener listener) {
        Assert.isNotNull((Object)listener);
        this.listenerWrapper.add(listener);
    }

    public void removeUIProcessChangedListener(IUIProcessChangeListener listener) {
        this.listenerWrapper.remove(listener);
    }

    private final class CancelListener
    implements PropertyChangeListener {
        private CancelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("cancel".equals(event.getPropertyName())) {
                UIProcess.this.job.cancel();
            }
        }
    }

    private final class InternalJob
    extends Job {
        public InternalJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            UIProcess.this.beforeRun(monitor);
            if (UIProcess.this.forceMonitorBegin()) {
                monitor.beginTask(this.getName(), UIProcess.this.getTotalWork());
            }
            boolean state = false;
            try {
                state = UIProcess.this.runJob(monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                if (!monitor.isCanceled()) {
                    monitor.setCanceled(true);
                }
            }
            catch (Throwable t) {
                ((IExceptionHandlerManager)Service.get((BundleContext)Activator.getDefault().getContext(), IExceptionHandlerManager.class)).handleException(t);
            }
            monitor.done();
            UIProcess.this.afterRun(monitor);
            ProgressProviderBridge.instance().unregisterMapping(this);
            return state ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }
}

