/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.Millis;
import org.eclipse.riena.ui.swt.AbstractStatuslineComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class StatuslineTime
extends AbstractStatuslineComposite {
    protected SimpleDateFormat format;
    private CLabel timeLabel;
    private final StatuslineUpdateJob updateJob = new StatuslineUpdateJob();
    private static final long A_SECOND = Millis.seconds((int)1);
    private static final Logger LOGGER = Log4r.getLogger(StatuslineTime.class);

    public StatuslineTime(Composite parent, int style) {
        super(parent, style | 0x80000);
        this.updateTime();
    }

    @Override
    protected void createContents() {
        this.timeLabel = new CLabel((Composite)this, 16384);
        this.timeLabel.setBackground(LnfManager.getLnf().getColor("statusline.background"));
    }

    public void dispose() {
        super.dispose();
        this.updateJob.cancel();
        SwtUtilities.dispose((Widget)this.timeLabel);
    }

    protected SimpleDateFormat getFormat() {
        if (this.format == null) {
            this.format = new SimpleDateFormat("HH:mm");
        }
        return this.format;
    }

    private void updateTime() {
        String timeStrg = this.getFormat().format(new Date());
        if (this.timeLabel != null && !this.timeLabel.isDisposed()) {
            this.timeLabel.setText(timeStrg);
        }
        this.updateJob.schedule(A_SECOND);
    }

    private class StatuslineUpdateJob
    extends Job {
        public StatuslineUpdateJob() {
            super("StatuslineUpdater");
            this.setSystem(true);
        }

        protected IStatus run(final IProgressMonitor monitor) {
            if (!StatuslineTime.this.isDisposed() && !StatuslineTime.this.getDisplay().isDisposed()) {
                try {
                    StatuslineTime.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!monitor.isCanceled()) {
                                StatuslineTime.this.updateTime();
                            }
                        }
                    });
                }
                catch (SWTException e) {
                    LOGGER.log(4, "StatuslineUpdateJob failed because of a disposed display.", (Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

