/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades;

import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;

public final class FacadeFactory {
    private FacadeFactory() {
    }

    public static <T> T newFacade(Class<T> type) {
        String suffix = "rap".equals(SWT.getPlatform()) ? "RAP" : "RCP";
        return FacadeFactory.instantiateClass(type, suffix);
    }

    public static <T> T newImpl(Class<T> type) {
        return FacadeFactory.instantiateClass(type, "Impl");
    }

    private static <T> T instantiateClass(Class<T> type, String suffix) {
        String name = String.valueOf(type.getName()) + suffix;
        try {
            return type.cast(type.getClassLoader().loadClass(name).newInstance());
        }
        catch (ClassCastException e) {
            String msg = NLS.bind((String)"Could not create an instance of {0} because it is not a {1}", (Object)name, (Object)type.getName());
            throw new RuntimeException(msg, e);
        }
        catch (Throwable throwable) {
            String msg = NLS.bind((String)"Could not load {0}", (Object)name);
            throw new RuntimeException(msg, throwable);
        }
    }
}

