/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.cache.LRUHashMap;
import org.eclipse.riena.core.singleton.SessionSingletonProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.lnf.IgnoreLnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class LnFUpdater {
    private static final Map<String, Object> RESOURCE_CACHE = LRUHashMap.createSynchronizedLRUHashMap((int)200);
    private static final Object NULL_RESOURCE = new Object();
    private static final String EMPTY_STRING = "";
    private static final SingletonProvider<LnFUpdater> LNFU = new SessionSingletonProvider(LnFUpdater.class);
    private static final Logger LOGGER = Log4r.getLogger(LnFUpdater.class);
    private static final String PROPERTY_RIENA_LNF_UPDATE_VIEW = "riena.lnf.update.view";
    private static final String[] ANYWAY_SET_PROPERTIES = new String[]{"background", "foreground"};
    private final Composite shellComposite = new Composite((Composite)new Shell(), 0);
    private final Map<Class<? extends Control>, String> simpleNames = new HashMap<Class<? extends Control>, String>();
    private final Map<Class<? extends Control>, List<PropertyDescriptor>> controlProperties = new HashMap<Class<? extends Control>, List<PropertyDescriptor>>();
    private final Map<String, Map<String, Object>> defaultPropertyValues = new HashMap<String, Map<String, Object>>();
    private final List<PropertyDescriptor> emptyDescriptors = Collections.emptyList();
    private boolean dirtyLayout;

    public static LnFUpdater getInstance() {
        return (LnFUpdater)LNFU.getInstance();
    }

    public void clearCache() {
        RESOURCE_CACHE.clear();
        this.defaultPropertyValues.clear();
        this.controlProperties.clear();
        this.simpleNames.clear();
        this.emptyDescriptors.clear();
    }

    private LnFUpdater() {
    }

    public void updateUIControls(Composite parent, boolean updateLayout) {
        if (this.checkPropertyUpdateView()) {
            this.setDirtyLayout(false);
            this.updateUIControlsRecursive(parent, false);
        } else {
            this.setDirtyLayout(true);
        }
        if (updateLayout) {
            this.updateLayout(parent);
        }
    }

    public void updateUIControlColors(Composite parent) {
        if (this.checkPropertyUpdateView()) {
            this.updateUIControlsRecursive(parent, true);
        }
    }

    public void updateUIControlsAfterBind(Composite parent) {
        this.updateUIControls(parent, true);
    }

    private void updateLayout(Composite parent) {
        if (this.isDirtyLayout()) {
            parent.layout(true, true);
            this.setDirtyLayout(false);
        }
    }

    private void updateUIControlsRecursive(Composite parent, boolean onlyColor) {
        Control[] controls;
        Control[] controlArray = controls = parent.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control uiControl = controlArray[n2];
            this.updateUIControl(uiControl, onlyColor);
            if (uiControl instanceof Composite) {
                this.updateUIControlsRecursive((Composite)uiControl, onlyColor);
            }
            ++n2;
        }
    }

    private boolean checkPropertyUpdateView() {
        return Boolean.getBoolean(PROPERTY_RIENA_LNF_UPDATE_VIEW);
    }

    public void updateUIControl(Control control) {
        this.updateUIControl(control, false);
    }

    private void updateUIControl(Control control, boolean onlyColor) {
        if (!this.checkPropertyUpdateView()) {
            return;
        }
        int classModifiers = control.getClass().getModifiers();
        if (!Modifier.isPublic(classModifiers)) {
            return;
        }
        if (this.ignoreControl(control)) {
            return;
        }
        if (!this.checkLnfKeys(control)) {
            return;
        }
        List<PropertyDescriptor> properties = this.getProperties(control);
        for (PropertyDescriptor property : properties) {
            Object newValue;
            if (onlyColor && property.getPropertyType() != Color.class || (newValue = this.getLnfValue(control, property)) == null) continue;
            boolean anyway = this.isAnywayProperty(property);
            Object currentValue = this.getPropertyValue(control, property);
            if (anyway && this.valuesEquals(currentValue, newValue) || this.hasNoDefaultValue(control, property, currentValue)) continue;
            try {
                Method setter = property.getWriteMethod();
                setter.invoke((Object)control, newValue);
                if (anyway) continue;
                this.setDirtyLayout(true);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(2, this.getErrorMessage(control, property), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.log(2, this.getErrorMessage(control, property), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.log(2, this.getErrorMessage(control, property), (Throwable)e);
            }
        }
    }

    private boolean checkLnfKeys(Control control) {
        Class<?> controlClass = control.getClass();
        if (this.checkLnfClassKeys(controlClass)) {
            return true;
        }
        RienaDefaultLnf lnf = LnfManager.getLnf();
        String style = (String)control.getData("lnfStyle");
        return lnf.containsLnfResourcePrefix(style);
    }

    private boolean checkLnfClassKeys(Class<? extends Control> controlClass) {
        RienaDefaultLnf lnf;
        String className = this.getSimpleClassName(controlClass);
        if (className.length() != 0 && (lnf = LnfManager.getLnf()).containsLnfResourcePrefix(className)) {
            return true;
        }
        Class<? extends Control> superclass = controlClass.getSuperclass();
        if (Control.class.isAssignableFrom(superclass)) {
            return this.checkLnfClassKeys(superclass);
        }
        return false;
    }

    private String getSimpleClassName(Class<? extends Control> controlClass) {
        String simpleName = this.simpleNames.get(controlClass);
        if (simpleName == null) {
            simpleName = this.getSimpleClassNameBasic(controlClass);
            this.simpleNames.put(controlClass, simpleName);
        }
        return simpleName;
    }

    private String getSimpleClassNameBasic(Class<? extends Control> controlClass) {
        String simpleName;
        Class<? extends Control> clazz = controlClass;
        while ((simpleName = clazz.getSimpleName()).length() == 0) {
            if (Control.class.isAssignableFrom(clazz = clazz.getSuperclass())) continue;
            return EMPTY_STRING;
        }
        return simpleName;
    }

    private boolean hasNoDefaultValue(Control control, PropertyDescriptor property, Object currentValue) {
        Method getter = property.getReadMethod();
        if (getter != null) {
            Object defaultValue = this.getDefaultPropertyValue(control, property);
            return !this.valuesEquals(defaultValue, currentValue);
        }
        return false;
    }

    private boolean valuesEquals(Object value1, Object value2) {
        if (value1 != null) {
            Object[] fontData1 = this.getFontData(value1);
            Object[] fontData2 = this.getFontData(value2);
            if (fontData1 != null && fontData2 != null) {
                return Arrays.equals(fontData1, fontData2);
            }
            RGB rgb1 = this.getRgb(value1);
            RGB rgb2 = this.getRgb(value2);
            if (rgb1 != null && rgb2 != null) {
                return rgb1.equals((Object)rgb2);
            }
            return value1.equals(value2);
        }
        return true;
    }

    private FontData[] getFontData(Object value) {
        if (value instanceof FontData[]) {
            return (FontData[])value;
        }
        if (value instanceof Font) {
            return ((Font)value).getFontData();
        }
        return null;
    }

    private RGB getRgb(Object value) {
        if (value instanceof RGB) {
            return (RGB)value;
        }
        if (value instanceof Color) {
            return ((Color)value).getRGB();
        }
        return null;
    }

    private Object getDefaultPropertyValue(Control control, PropertyDescriptor property) {
        Class<?> controlClass = control.getClass();
        String mapKey = this.createDefaultPropertiesClassKey(controlClass, control.getStyle());
        Map<String, Object> defaultValues = this.defaultPropertyValues.get(mapKey);
        if (defaultValues == null) {
            Control defaultControl = this.createDefaultControl(controlClass, control.getStyle());
            if (defaultControl != null) {
                List<PropertyDescriptor> properties = this.getProperties(control);
                defaultValues = new Hashtable<String, Object>(properties.size());
                for (PropertyDescriptor defaultProperty : properties) {
                    Object value = this.getPropertyValue(defaultControl, defaultProperty);
                    if ((value = this.getResourceData(value)) == null) continue;
                    defaultValues.put(defaultProperty.getName(), value);
                }
                defaultControl.dispose();
                this.defaultPropertyValues.put(mapKey, defaultValues);
            } else {
                LOGGER.log(1, "Cannot create an instance of \"" + controlClass.getName() + "\"");
            }
        }
        if (defaultValues == null) {
            return null;
        }
        return defaultValues.get(property.getName());
    }

    private Object getResourceData(Object object) {
        if (!(object instanceof Resource)) {
            return object;
        }
        Resource resource = (Resource)object;
        if (resource.isDisposed()) {
            return resource;
        }
        if (resource instanceof Font) {
            return ((Font)resource).getFontData();
        }
        if (resource instanceof Color) {
            return ((Color)resource).getRGB();
        }
        return resource;
    }

    private Object getPropertyValue(Control control, PropertyDescriptor property) {
        Method getter = property.getReadMethod();
        if (getter == null) {
            return null;
        }
        try {
            return getter.invoke((Object)control, new Object[0]);
        }
        catch (Exception failure) {
            if (control.getClass().getName().equals("org.eclipse.swt.nebula.widgets.compositetable.CompositeTable")) {
                return null;
            }
            String message = "Cannot get the value of the property \"" + property.getName() + "\" of the class \"" + control.getClass().getName() + "\".";
            LOGGER.log(1, message, (Throwable)failure);
            return null;
        }
    }

    private String getErrorMessage(Control control, PropertyDescriptor property) {
        Class<?> controlClass = control.getClass();
        StringBuilder sb = new StringBuilder("Cannot update property ");
        sb.append("\"" + property.getName() + "\"");
        sb.append(" of the class ");
        sb.append("\"" + controlClass.getName() + "\"");
        return sb.toString();
    }

    private List<PropertyDescriptor> getProperties(Control control) {
        Class<?> controlClass = control.getClass();
        List<PropertyDescriptor> propertyDescriptors = this.controlProperties.get(controlClass);
        if (propertyDescriptors == null) {
            try {
                PropertyDescriptor[] descriptors = Introspector.getBeanInfo(controlClass).getPropertyDescriptors();
                propertyDescriptors = new ArrayList<PropertyDescriptor>(descriptors.length);
                PropertyDescriptor[] propertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    Method getter;
                    int modifiers;
                    PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                    Method setter = descriptor.getWriteMethod();
                    if (setter != null && Modifier.isPublic(modifiers = setter.getModifiers()) && (getter = descriptor.getReadMethod()) != null && Modifier.isPublic(modifiers = getter.getModifiers()) && !this.ignoreProperty(controlClass, descriptor)) {
                        propertyDescriptors.add(descriptor);
                    }
                    ++n2;
                }
            }
            catch (IntrospectionException introspectionException) {
                propertyDescriptors = this.emptyDescriptors;
            }
            this.controlProperties.put(controlClass, propertyDescriptors);
        }
        return propertyDescriptors;
    }

    private Object getLnfValue(Control control, PropertyDescriptor property) {
        Object lnfValue = this.getLnfStyleValue(control, property);
        if (lnfValue == null) {
            Class<?> controlClass = control.getClass();
            lnfValue = this.getLnfValue(controlClass, property);
        }
        return lnfValue;
    }

    private Object getLnfValue(Class<? extends Control> controlClass, PropertyDescriptor property) {
        Class<? extends Control> superclass;
        String lnfKey = this.generateLnfKey(controlClass, property);
        Object lnfValue = RESOURCE_CACHE.get(lnfKey);
        if (lnfValue != null) {
            return lnfValue == NULL_RESOURCE ? null : lnfValue;
        }
        lnfValue = LnfManager.getLnf().getResource(lnfKey);
        if (lnfValue == null && Control.class.isAssignableFrom(superclass = controlClass.getSuperclass())) {
            lnfValue = this.getLnfValueInternal(superclass, property);
        }
        RESOURCE_CACHE.put(lnfKey, lnfValue == null ? NULL_RESOURCE : lnfValue);
        return lnfValue;
    }

    private Object getLnfValueInternal(Class<? extends Control> controlClass, PropertyDescriptor property) {
        Class<? extends Control> superclass;
        String lnfKey = this.generateLnfKey(controlClass, property);
        Object lnfValue = LnfManager.getLnf().getResource(lnfKey);
        if (lnfValue == null && Control.class.isAssignableFrom(superclass = controlClass.getSuperclass())) {
            lnfValue = this.getLnfValueInternal(superclass, property);
        }
        return lnfValue;
    }

    private String generateLnfKey(Class<? extends Control> controlClass, PropertyDescriptor property) {
        String controlName = this.getSimpleClassName(controlClass);
        StringBuilder lnfKey = new StringBuilder(controlName);
        lnfKey.append('.');
        lnfKey.append(property.getName());
        return lnfKey.toString();
    }

    private Object getLnfStyleValue(Control control, PropertyDescriptor property) {
        String style = (String)control.getData("lnfStyle");
        if (StringUtils.isEmpty((CharSequence)style)) {
            return null;
        }
        RienaDefaultLnf lnf = LnfManager.getLnf();
        StringBuilder lnfKey = new StringBuilder(style);
        lnfKey.append('.');
        lnfKey.append(property.getName());
        return lnf.getResource(lnfKey.toString());
    }

    private Control createDefaultControl(Class<? extends Control> controlClass, int style) {
        Composite parent = this.shellComposite;
        Control defaultControl = this.getControl(controlClass, parent, style);
        if (defaultControl != null) {
            return defaultControl;
        }
        defaultControl = this.getControl(controlClass, parent);
        if (defaultControl != null) {
            return defaultControl;
        }
        try {
            Constructor<?>[] constructors;
            Constructor<?>[] constructorArray = constructors = controlClass.getConstructors();
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                Class<?>[] paramTypes = constructor.getParameterTypes();
                Object[] params = new Object[paramTypes.length];
                boolean parentAssigned = false;
                boolean styleAssigned = false;
                int i = 0;
                while (i < paramTypes.length) {
                    if (paramTypes[i].isAssignableFrom(Composite.class) && !parentAssigned) {
                        params[i] = parent;
                        parentAssigned = true;
                    } else if (paramTypes[i].isAssignableFrom(Integer.TYPE) && !styleAssigned) {
                        params[i] = style;
                        styleAssigned = true;
                    } else {
                        try {
                            params[i] = paramTypes[i].newInstance();
                        }
                        catch (Exception exception) {
                            params[i] = null;
                        }
                    }
                    ++i;
                }
                try {
                    defaultControl = (Control)constructor.newInstance(params);
                }
                catch (Exception exception) {
                    defaultControl = null;
                }
                if (defaultControl == null) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (SecurityException e) {
            LOGGER.log(2, "Exception while creating default control the hard way for " + controlClass, (Throwable)e);
        }
        return defaultControl;
    }

    private Control getControl(Class<? extends Control> controlClass, Composite parent, int style) {
        try {
            Constructor<? extends Control> constructor = controlClass.getConstructor(Composite.class, Integer.TYPE);
            return constructor.newInstance(parent, style);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception e) {
            LOGGER.log(2, "Exception while creating default control with composite and style for " + controlClass, (Throwable)e);
            return null;
        }
    }

    private Control getControl(Class<? extends Control> controlClass, Composite parent) {
        try {
            Constructor<? extends Control> constructor = controlClass.getConstructor(Composite.class);
            return constructor.newInstance(parent);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception e) {
            LOGGER.log(2, "Exception while creating default control with composite for " + controlClass, (Throwable)e);
            return null;
        }
    }

    private void setDirtyLayout(boolean dirtyLayout) {
        this.dirtyLayout = dirtyLayout;
    }

    private boolean isDirtyLayout() {
        return this.dirtyLayout;
    }

    private boolean ignoreProperty(Class<? extends Control> controlClass, PropertyDescriptor property) {
        return this.ignoreProperty(controlClass, property.getName());
    }

    private boolean ignoreControl(Control control) {
        return this.ignoreProperty(control.getClass(), "*");
    }

    private boolean ignoreProperty(Class<?> controlClass, String property) {
        if (!Control.class.isAssignableFrom(controlClass)) {
            return false;
        }
        IgnoreLnFUpdater ignoreLnfUpdater = controlClass.getAnnotation(IgnoreLnFUpdater.class);
        if (ignoreLnfUpdater == null) {
            return false;
        }
        String[] stringArray = ignoreLnfUpdater.value();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoreProp = stringArray[n2];
            if (ignoreProp != null && ignoreProp.equals(property)) {
                return true;
            }
            ++n2;
        }
        return this.ignoreProperty(controlClass.getSuperclass(), property);
    }

    private String createDefaultPropertiesClassKey(Class<? extends Control> controlClass, int style) {
        return String.valueOf(controlClass.toString()) + "#" + style;
    }

    private boolean isAnywayProperty(PropertyDescriptor property) {
        String propName = property.getName();
        String[] stringArray = ANYWAY_SET_PROPERTIES;
        int n = ANYWAY_SET_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            String anywayPropName = stringArray[n2];
            if (propName.equals(anywayPropName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

