/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.editor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.NlsTablePage;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.editor.NlsTypeEditorInput;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class NlsEditor
extends MultiPageEditorPart {
    private int m_tablePageIndex = -1;
    public static final String EDITOR_ID = "org.eclipse.scout.nls.sdk.nlsEditor";

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof JarEntryEditorInput) {
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor", (boolean)true);
            this.setSite(null);
            this.setInput(null);
            return;
        }
        if (input instanceof IStorageEditorInput) {
            IStorage storage = null;
            try {
                storage = ((IStorageEditorInput)input).getStorage();
            }
            catch (CoreException e) {
                SdkLog.warning((Object[])new Object[]{e});
            }
            if (storage instanceof JarEntryFile) {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"org.eclipse.ui.DefaultTextEditor", (boolean)true);
                this.setSite(null);
                this.setInput(null);
                return;
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    protected void createPages() {
        this.createTablePage();
    }

    private void createTablePage() {
        INlsProject nlsProjects = null;
        IEditorInput input = this.getEditorInput();
        try {
            if (input instanceof FileEditorInput) {
                nlsProjects = NlsCore.getNlsWorkspace().getNlsProject(new Object[]{((FileEditorInput)input).getFile()});
            } else if (input instanceof NlsTypeEditorInput) {
                nlsProjects = NlsCore.getNlsWorkspace().getNlsProject(new Object[]{((NlsTypeEditorInput)input).getType()});
            }
            if (nlsProjects != null) {
                this.setPartName(nlsProjects.getName());
            } else {
                this.setPartName("Translations");
            }
            NlsTablePage page = new NlsTablePage(this.getContainer(), nlsProjects);
            this.m_tablePageIndex = this.addPage((Control)page);
            this.setPageText(this.m_tablePageIndex, "Translations");
        }
        catch (CoreException e) {
            SdkLog.error((String)"could not load file: {}", (Object[])new Object[]{input.getName(), e});
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }
}

