/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.fields;

import java.text.Collator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.ISmartDialogListener;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.fields.ISmartFieldModel;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SmartDialog {
    private Shell m_shell;
    private ISmartFieldModel m_smartModel;
    private Table m_table;
    private TableViewer m_viewer;
    private Label m_infoLabel;
    private Point m_defaultSize = new Point(200, 250);
    private final P_SmartFieldTableModel m_smartTableModel;
    private final List<ISmartDialogListener> m_smartDialogListeners = new LinkedList<ISmartDialogListener>();
    private final Shell m_parentShell;
    private static final Collator COLLATOR = Collator.getInstance(Locale.getDefault());

    public SmartDialog(Shell parentShell) {
        this.m_smartTableModel = new P_SmartFieldTableModel();
        this.m_parentShell = parentShell;
        this.createComponent(parentShell);
    }

    protected void createComponent(Shell parentShell) {
        this.m_shell = new Shell(parentShell, 16384);
        this.m_shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
                SmartDialog.this.m_shell.setVisible(false);
            }

            public void shellDeactivated(ShellEvent e) {
                SmartDialog.this.m_shell.setVisible(false);
            }

            public void shellActivated(ShellEvent e) {
                SmartDialog.this.updateTableWith();
            }
        });
        this.m_shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                SmartDialog.this.updateTableWith();
            }
        });
        CLabel borderComp = new CLabel((Composite)this.m_shell, 1);
        borderComp.setBackground(borderComp.getDisplay().getSystemColor(15));
        Composite rootArea = new Composite((Composite)borderComp, 1);
        this.m_table = new Table(rootArea, 66308);
        this.m_table.setHeaderVisible(false);
        this.m_table.setLinesVisible(false);
        this.m_table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && SmartDialog.this.m_table.getSelectionIndex() == 0) {
                    SmartDialog.this.m_table.traverse(8);
                }
            }
        });
        TableColumn col = new TableColumn(this.m_table, 131072);
        col.setWidth(100);
        this.m_viewer = new TableViewer(this.m_table);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)this.m_smartTableModel);
        this.m_viewer.setContentProvider((IContentProvider)this.m_smartTableModel);
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SmartDialog.this.handleItemSelection(((StructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.m_infoLabel = new Label(rootArea, 1);
        this.m_shell.setLayout((Layout)new FillLayout());
        FillLayout borderLayout = new FillLayout();
        borderLayout.marginHeight = 2;
        borderLayout.marginWidth = 2;
        borderComp.setLayout((Layout)borderLayout);
        rootArea.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)this.m_infoLabel, 0);
        this.m_table.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_infoLabel.setLayoutData((Object)data);
    }

    private void updateTableWith() {
        this.m_table.getColumn(0).setWidth(this.m_table.getClientArea().width);
    }

    protected void lazyCreateComponent() {
        if (this.m_shell == null || this.m_shell.isDisposed()) {
            this.createComponent(this.m_parentShell);
        }
    }

    public void setSmartFieldModel(ISmartFieldModel model) {
        this.m_smartModel = model;
    }

    public void setFont(Font font) {
        this.m_table.setFont(font);
    }

    public Font getFont() {
        return this.m_table.getFont();
    }

    public void setInitialShellSize(Point initialSize) {
        this.m_defaultSize = initialSize;
    }

    public void addSmartDialogListener(ISmartDialogListener listener) {
        this.m_smartDialogListeners.add(listener);
    }

    public void removeSmartDialogListener(ISmartDialogListener listener) {
        this.m_smartDialogListeners.remove(listener);
    }

    public void lazyOpen(String text) {
        Control c = Display.getDefault().getCursorControl();
        if (c != null) {
            this.open(c.toDisplay(new Point(0, c.getBounds().height)), text);
        } else {
            Rectangle bounds = Display.getDefault().getBounds();
            this.open(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2), text);
        }
    }

    public void open(Point location, String text) {
        List<Object> props = this.m_smartModel.getProposals(text);
        this.openInternal(location, props);
    }

    public void open(Rectangle bounds, String text) {
        this.m_defaultSize = new Point(bounds.width, bounds.height);
        this.open(new Point(bounds.x, bounds.y), text);
    }

    public void lazyOpen(Point location, String text) {
        List<Object> props = this.m_smartModel.getProposals(text);
        if (props.size() == 1) {
            this.notifyItemSelection(props.get(0));
        } else {
            this.openInternal(location, props);
        }
    }

    public void lazyOpen(Rectangle bounds, String text) {
        this.m_defaultSize = new Point(bounds.width, bounds.height);
        this.lazyOpen(new Point(bounds.x, bounds.y), text);
    }

    private void openInternal(Point location, List<Object> proposals) {
        this.lazyCreateComponent();
        if (this.m_defaultSize.x < 0) {
            this.m_defaultSize.x = 250;
        }
        if (this.m_defaultSize.y < 0) {
            this.m_defaultSize.y = 300;
        }
        if (proposals.size() == 0) {
            this.m_infoLabel.setText("no items could be found");
        } else {
            this.m_infoLabel.setText(String.valueOf(proposals.size()) + " items found");
        }
        this.m_smartTableModel.setItems(proposals);
        this.m_viewer.setInput((Object)this.m_smartTableModel);
        this.m_viewer.refresh(true);
        this.m_shell.layout(true);
        this.m_shell.setLocation(location);
        this.m_shell.setSize(this.m_defaultSize);
        this.m_shell.setVisible(true);
    }

    protected void handleItemSelection(Object item) {
        this.notifyItemSelection(((P_CompareableSmartItem)item).getItem());
    }

    public boolean isVisible() {
        return this.m_shell.isVisible();
    }

    protected void notifyItemSelection(Object item) {
        ArrayList<ISmartDialogListener> listeners = new ArrayList<ISmartDialogListener>(this.m_smartDialogListeners);
        for (ISmartDialogListener listener : listeners) {
            listener.itemSelected(item);
        }
        this.m_shell.setVisible(false);
    }

    private final class P_CompareableSmartItem
    implements Comparable<P_CompareableSmartItem> {
        private final Object m_item;

        private P_CompareableSmartItem(Object item) {
            this.m_item = item;
        }

        public int hashCode() {
            return SmartDialog.this.m_smartModel.getText(this.m_item).hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof P_CompareableSmartItem)) {
                return false;
            }
            String me = SmartDialog.this.m_smartModel.getText(this.m_item);
            String other = SmartDialog.this.m_smartModel.getText(((P_CompareableSmartItem)obj).getItem());
            return Objects.equals(me, other);
        }

        @Override
        public int compareTo(P_CompareableSmartItem o) {
            return COLLATOR.compare(SmartDialog.this.m_smartModel.getText(this.m_item), SmartDialog.this.m_smartModel.getText(o.getItem()));
        }

        public Object getItem() {
            return this.m_item;
        }
    }

    private final class P_SmartFieldTableModel
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private final Set<P_CompareableSmartItem> m_items = new TreeSet<P_CompareableSmartItem>();

        private P_SmartFieldTableModel() {
        }

        public void setItems(List<Object> items) {
            this.m_items.clear();
            for (Object object : items) {
                this.m_items.add(new P_CompareableSmartItem(object));
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.m_items.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return SmartDialog.this.m_smartModel.getImage(((P_CompareableSmartItem)element).getItem());
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return SmartDialog.this.m_smartModel.getText(((P_CompareableSmartItem)element).getItem());
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }
}

