/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util.ast;

import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.util.CoreScoutUtils;
import org.eclipse.scout.sdk.core.util.IFilter;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerationContext;
import org.eclipse.scout.sdk.s2e.classid.ClassIdGenerators;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AbstractAstBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstMethodBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.ui.internal.util.ast.WrappedTrackedNodePosition;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstTypeBuilder<INSTANCE extends AstTypeBuilder<INSTANCE>>
extends AbstractAstBuilder<INSTANCE> {
    private final INSTANCE m_return = this;
    private String m_nlsMethodName;
    private String m_typeName;
    private String m_readOnlyNameSuffix;
    private Type m_superType;
    private String m_orderDefinitionTypeFqn;
    private int m_pos = -1;
    private boolean m_calcOrderNr = true;
    private boolean m_createOrder;
    private boolean m_createClassId;
    private String m_proposalBaseFqn;
    private TypeDeclaration m_resultType;

    protected AstTypeBuilder(AstNodeFactory owner) {
        super(owner);
    }

    public INSTANCE withNlsMethod(String methodName) {
        this.m_nlsMethodName = methodName;
        return this.m_return;
    }

    public INSTANCE withName(String name) {
        this.m_typeName = name;
        return this.m_return;
    }

    public INSTANCE withReadOnlyNameSuffix(String readOnlyNameSuffix) {
        this.m_readOnlyNameSuffix = readOnlyNameSuffix;
        return this.m_return;
    }

    public INSTANCE withSuperType(Type superType) {
        this.m_superType = superType;
        return this.m_return;
    }

    public INSTANCE atPosition(int pos) {
        this.m_pos = pos;
        return this.m_return;
    }

    public INSTANCE withCalculatedOrder(boolean autoCalcOrder) {
        this.m_calcOrderNr = autoCalcOrder;
        return this.m_return;
    }

    public INSTANCE withOrderDefinitionType(String fqn) {
        this.m_orderDefinitionTypeFqn = fqn;
        return this.m_return;
    }

    public INSTANCE withOrder(boolean createOrder) {
        this.m_createOrder = createOrder;
        return this.m_return;
    }

    public INSTANCE withClassId(boolean createClassId) {
        this.m_createClassId = createClassId;
        return this.m_return;
    }

    public INSTANCE withProposalBaseFqn(String valueFieldInterfaceFqn) {
        this.m_proposalBaseFqn = valueFieldInterfaceFqn;
        return this.m_return;
    }

    public String getProposalBaseFqn() {
        return this.m_proposalBaseFqn;
    }

    public TypeDeclaration get() {
        return this.m_resultType;
    }

    public String getNlsMethodName() {
        return this.m_nlsMethodName;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlyNameSuffix;
    }

    public Type getSuperType() {
        return this.m_superType;
    }

    public String getOrderDefinitionType() {
        return this.m_orderDefinitionTypeFqn;
    }

    public int getInsertPosition() {
        return this.m_pos;
    }

    public boolean isCalculateOrderValue() {
        return this.m_calcOrderNr;
    }

    public boolean isCreateOrderAnnotation() {
        return this.m_createOrder;
    }

    public boolean isCreateClassIdAnnotation() {
        return this.m_createClassId;
    }

    @Override
    public INSTANCE insert() {
        ILinkedPositionHolder links;
        AST ast = this.getFactory().getAst();
        if (this.getReadOnlySuffix() == null) {
            this.withReadOnlyNameSuffix("");
        }
        boolean createClassId = this.isCreateClassIdAnnotation() && ClassIdGenerators.isAutomaticallyCreateClassIdAnnotation();
        this.m_resultType = ast.newTypeDeclaration();
        this.m_resultType.setInterface(false);
        for (Modifier.ModifierKeyword mod : this.getModifiers()) {
            this.m_resultType.modifiers().add(ast.newModifier(mod));
        }
        SimpleName typeName = ast.newSimpleName(String.valueOf(this.getTypeName()) + this.getReadOnlySuffix());
        this.m_resultType.setName(typeName);
        if (this.getSuperType() != null) {
            this.m_resultType.setSuperclassType(this.getSuperType());
        }
        if ((links = this.getFactory().getLinkedPositionHolder()) != null && this.isCreateLinks()) {
            WrappedTrackedNodePosition typeNamePos = new WrappedTrackedNodePosition(this.getFactory().getRewrite().track((ASTNode)this.m_resultType.getName()), 0, -this.getReadOnlySuffix().length());
            links.addLinkedPosition(typeNamePos, true, "TYPE_NAME");
            if (this.getSuperType() != null) {
                Type superTypeLinkNode = this.getSuperType();
                if (superTypeLinkNode instanceof ParameterizedType) {
                    superTypeLinkNode = ((ParameterizedType)superTypeLinkNode).getType();
                }
                links.addLinkedPosition(this.getFactory().getRewrite().track((ASTNode)superTypeLinkNode), true, "SUPER_TYPE");
            }
            if (this.getProposalBaseFqn() != null) {
                links.addLinkedPositionProposalsHierarchy("SUPER_TYPE", this.getProposalBaseFqn());
            }
        }
        String declaringTypeFqn = null;
        if (this.isCreateOrderAnnotation() && this.isCalculateOrderValue() || createClassId) {
            declaringTypeFqn = AstUtils.getFullyQualifiedName((TypeDeclaration)this.getDeclaringType(), (TypeDeclaration)this.getFactory().getType());
        }
        if (this.isCreateOrderAnnotation()) {
            double newOrder = 1000.0;
            if (this.isCalculateOrderValue()) {
                newOrder = CoreScoutUtils.getNewViewOrderValue((IType)this.getFactory().getJavaEnvironment().findType(declaringTypeFqn), (String)this.getOrderDefinitionType(), (int)this.getInsertPosition());
            }
            SingleMemberAnnotation order = ast.newSingleMemberAnnotation();
            String orderRef = this.getFactory().getImportRewrite().addImport("org.eclipse.scout.rt.platform.Order");
            order.setTypeName(ast.newName(orderRef));
            NumberLiteral orderValue = ast.newNumberLiteral(AstTypeBuilder.convertOrderToJavaSourceString(newOrder));
            order.setValue((Expression)orderValue);
            AstUtils.addAnnotationTo((Annotation)order, (BodyDeclaration)this.m_resultType);
        }
        if (createClassId) {
            String fqn = declaringTypeFqn + '$' + this.getTypeName();
            SingleMemberAnnotation classIdAnnotation = this.getFactory().newClassIdAnnotation(new ClassIdGenerationContext(fqn));
            AstUtils.addAnnotationTo((Annotation)classIdAnnotation, (BodyDeclaration)this.m_resultType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getNlsMethodName())) {
            ((AstMethodBuilder)this.getFactory().newNlsMethod(this.getNlsMethodName()).in(this.m_resultType)).insert();
        }
        ListRewrite typeRewrite = this.getFactory().getRewrite().getListRewrite((ASTNode)this.getDeclaringType(), this.getDeclaringType().getBodyDeclarationsProperty());
        ASTNode previousNode = AstUtils.getPreviousNode((ASTNode)this.getDeclaringType(), (int)this.getInsertPosition(), (IFilter)new P_EnsureElementInRewriteFilter(typeRewrite));
        if (previousNode == null) {
            typeRewrite.insertFirst((ASTNode)this.m_resultType, null);
        } else {
            typeRewrite.insertAfter((ASTNode)this.m_resultType, previousNode, null);
        }
        return this.m_return;
    }

    protected static String convertOrderToJavaSourceString(double order) {
        NumberFormat f = NumberFormat.getNumberInstance(Locale.ENGLISH);
        f.setGroupingUsed(false);
        String newOrderStr = f.format(order);
        String zeroSuffix = ".0";
        if (newOrderStr.endsWith(".0")) {
            newOrderStr = newOrderStr.substring(0, newOrderStr.length() - ".0".length());
        }
        if (order > 2.147483647E9 && newOrderStr.indexOf(46) < 0) {
            newOrderStr = String.valueOf(newOrderStr) + 'd';
        }
        return newOrderStr;
    }

    private static final class P_EnsureElementInRewriteFilter
    implements IFilter<ASTNode> {
        private final Set<Object> m_elements;

        private P_EnsureElementInRewriteFilter(ListRewrite declaringTypeRewrite) {
            List originalList = declaringTypeRewrite.getOriginalList();
            this.m_elements = new HashSet<Object>(originalList.size());
            for (Object element : originalList) {
                this.m_elements.add(element);
            }
        }

        public boolean evaluate(ASTNode element) {
            return this.m_elements.contains(element);
        }
    }
}

