/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.factory.ServiceFactory;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IParallelService;
import org.eclipse.sequoyah.device.framework.model.IService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManager {
    private static ServiceManager _instance;
    private List<IService> services = new ArrayList<IService>();

    private ServiceManager() {
    }

    public static ServiceManager getInstance() {
        if (_instance == null) {
            _instance = new ServiceManager();
        }
        return _instance;
    }

    public void loadServices() {
        this.services.clear();
        Collection collection = PluginUtils.getInstalledPlugins((String)"org.eclipse.sequoyah.device.framework.service");
        for (String string : collection) {
            try {
                this.services.add(ServiceFactory.createService(string));
            }
            catch (SequoyahException sequoyahException) {}
        }
    }

    public void listServices() {
        for (IService iService : this.services) {
            BasePlugin.logInfo((String)iService.toString());
        }
    }

    public static List<IService> getCommonServices(List<IInstance> list, boolean bl) {
        ArrayList arrayList = ServiceManager.getServices(list, bl, false);
        return arrayList == null ? new ArrayList(0) : arrayList;
    }

    public static List<IService> getAllServices(List<IInstance> list, boolean bl) {
        ArrayList arrayList = ServiceManager.getServices(list, bl, true);
        return arrayList == null ? new ArrayList(0) : arrayList;
    }

    private static List<IService> getServices(List<IInstance> list, boolean bl, boolean bl2) {
        ArrayList<IService> arrayList = null;
        HashMap<IInstance, List<IService>> hashMap = new HashMap<IInstance, List<IService>>(list.size());
        DeviceTypeRegistry deviceTypeRegistry = DeviceTypeRegistry.getInstance();
        ArrayList<IService> arrayList2 = new ArrayList<IService>(deviceTypeRegistry.getDeviceTypes().size() * 5);
        for (IInstance iInstance : list) {
            List<IService> list2 = ServiceManager.getAvailableServices(iInstance, bl);
            hashMap.put(iInstance, list2);
            for (IService iService : list2) {
                if (arrayList2.contains(iService)) continue;
                arrayList2.add(iService);
            }
        }
        arrayList = bl2 ? arrayList2 : ServiceManager.filterCommonServices(hashMap, arrayList2);
        return arrayList;
    }

    private static List<IService> getAvailableServices(IInstance iInstance, boolean bl) {
        String string = iInstance.getDeviceTypeId();
        IDeviceType iDeviceType = DeviceTypeRegistry.getInstance().getDeviceTypeById(string);
        List<IService> list = iDeviceType.getServices();
        ArrayList<IService> arrayList = new ArrayList<IService>(list.size());
        for (IService iService : list) {
            boolean bl2 = ServiceManager.isServiceAvailable(iInstance, iService);
            if (!bl2) continue;
            if (bl && iService instanceof IParallelService) {
                IParallelService iParallelService = (IParallelService)iService;
                bl2 = iParallelService.isParallelized();
            }
            if (!bl2) continue;
            arrayList.add(iService);
        }
        return arrayList;
    }

    public List<IService> getInstalledServices() {
        return new ArrayList<IService>(this.services);
    }

    private static List<IService> filterCommonServices(Map<IInstance, List<IService>> map, List<IService> list) {
        ArrayList<IService> arrayList = new ArrayList<IService>(list.size());
        for (IService iService : list) {
            boolean bl = true;
            Iterator<IInstance> iterator = map.keySet().iterator();
            while (iterator.hasNext() && bl) {
                IInstance iInstance = iterator.next();
                List<IService> list2 = map.get(iInstance);
                if (list2.contains(iService)) continue;
                bl = false;
            }
            if (!bl || arrayList.contains(iService)) continue;
            arrayList.add(iService);
        }
        return arrayList;
    }

    public static boolean isServiceAvailable(IInstance iInstance, IService iService) {
        boolean bl = false;
        String string = iInstance.getDeviceTypeId();
        IDeviceType iDeviceType = DeviceTypeRegistry.getInstance().getDeviceTypeById(string);
        List<IService> list = iDeviceType.getServices();
        bl = list.contains(iService);
        if (bl) {
            boolean bl2 = iInstance.getStateMachineHandler().isTransitioning();
            bl = iService.getStatusTransitions(iInstance.getDeviceTypeId(), iInstance.getStatus()) != null;
            bl = bl && !bl2;
        }
        return bl;
    }

    public static void runServices(final List<IInstance> list, final String string) throws SequoyahException {
        if (list != null) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    int n = 0;
                    List<IService> list2 = ServiceManager.getAllServices(list, false);
                    boolean bl = false;
                    Iterator<IService> iterator = list2.iterator();
                    IService iService = null;
                    while (!bl && iterator.hasNext()) {
                        iService = iterator.next();
                        bl = iService.getId().equals(string);
                    }
                    if (bl) {
                        Object object;
                        if (iService instanceof IParallelService) {
                            object = (IParallelService)iService;
                            n = object.getInterval();
                        }
                        object = iService.getHandler();
                        object.singleInit(list);
                        for (IInstance iInstance : list) {
                            try {
                                object.run(iInstance);
                                if (n <= 0) continue;
                                Thread.sleep(n);
                            }
                            catch (InterruptedException interruptedException) {
                                BasePlugin.logError((String)interruptedException.getMessage());
                            }
                            catch (SequoyahException sequoyahException) {
                                BasePlugin.logError((String)sequoyahException.getMessage());
                            }
                        }
                    }
                }
            });
            thread.start();
        }
    }
}

