/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.status;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sequoyah.device.framework.status.IStatus;
import org.eclipse.sequoyah.device.framework.status.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusRegistry {
    private Map<String, IStatus> status = new HashMap<String, IStatus>();
    private Map<String, String> statusUITooltip = new HashMap<String, String>();
    private static StatusRegistry _instance;

    private StatusRegistry() {
    }

    public static StatusRegistry getInstance() {
        if (_instance == null) {
            _instance = new StatusRegistry();
            StatusManager.getInstance().loadStatus();
        }
        return _instance;
    }

    public IStatus getStatus(String string) {
        return this.status.get(string);
    }

    public Collection<IStatus> getStatus() {
        return this.status.values();
    }

    public void setStatus(Map<String, IStatus> map) {
        this.status = map;
    }

    public void addStatus(IStatus iStatus) {
        this.status.put(iStatus.getId(), iStatus);
    }

    public void clear() {
        this.status.clear();
        this.statusUITooltip.clear();
    }

    public void addStatusTooltip(String string, String string2) {
        this.statusUITooltip.put(string, string2);
    }

    public String getTooltipTextForStatus(String string) {
        return this.statusUITooltip.get(string);
    }
}

