/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.tools.datamodel;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sequoyah.localization.tools.datamodel.LocaleInfo;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.StringLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringArrayNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationProject {
    private IProject project;
    private List<LocalizationFile> localizationFiles;
    private boolean dirty;
    private boolean dirtyMetaExtraData;

    public LocalizationProject(IProject iProject, List<LocalizationFile> list) {
        this.project = iProject;
        this.localizationFiles = list;
        for (LocalizationFile localizationFile : this.localizationFiles) {
            localizationFile.setLocalizationProject(this);
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public List<LocalizationFile> getLocalizationFiles() {
        return this.localizationFiles;
    }

    public void setLocalizationFiles(List<LocalizationFile> list) {
        this.localizationFiles = list;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirtyMetaExtraData() {
        return this.dirtyMetaExtraData;
    }

    public void setDirtyMetaExtraData(boolean bl) {
        this.dirtyMetaExtraData = bl;
    }

    public LocalizationFile getLocalizationFile(LocaleInfo localeInfo) {
        LocalizationFile localizationFile = null;
        boolean bl = false;
        Iterator<LocalizationFile> iterator = this.localizationFiles.iterator();
        while (iterator.hasNext() && !bl) {
            LocalizationFile localizationFile2 = iterator.next();
            if (!localizationFile2.getLocaleInfo().equals(localeInfo)) continue;
            localizationFile = localizationFile2;
            bl = true;
        }
        return localizationFile;
    }

    public LocalizationFile getLocalizationFile(IFile iFile) {
        LocalizationFile localizationFile = null;
        boolean bl = false;
        Iterator<LocalizationFile> iterator = this.localizationFiles.iterator();
        while (iterator.hasNext() && !bl) {
            LocalizationFile localizationFile2 = iterator.next();
            if (!localizationFile2.getFile().equals((Object)iFile)) continue;
            localizationFile = localizationFile2;
            bl = true;
        }
        return localizationFile;
    }

    public boolean addLocalizationFile(LocalizationFile localizationFile) {
        localizationFile.setLocalizationProject(this);
        return this.localizationFiles.add(localizationFile);
    }

    public boolean removeLocalizationFile(LocalizationFile localizationFile) {
        return this.localizationFiles.remove(localizationFile);
    }

    public Set<StringArrayNode> getAllStringArrays() {
        TreeSet<StringArrayNode> treeSet = new TreeSet<StringArrayNode>(new Comparator<StringArrayNode>(){

            @Override
            public int compare(StringArrayNode stringArrayNode, StringArrayNode stringArrayNode2) {
                return stringArrayNode.getKey().compareTo(stringArrayNode2.getKey());
            }
        });
        List<LocalizationFile> list = this.getLocalizationFiles();
        for (LocalizationFile localizationFile : list) {
            treeSet.addAll(((StringLocalizationFile)localizationFile).getStringArrays());
        }
        return treeSet;
    }
}

