/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.interpreter.api;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.interpreter.api.IEvaluationResult;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;

public class EvaluationResult
implements IEvaluationResult {
    private final Object rawValue;
    private final Diagnostic status;

    public static EvaluationResult of(Object o) {
        return EvaluationResult.of(o, Diagnostic.OK_INSTANCE);
    }

    public static EvaluationResult of(Object o, Diagnostic diag) {
        return new EvaluationResult(o, diag);
    }

    public static EvaluationResult noEvaluation() {
        return new EvaluationResult(null, Diagnostic.CANCEL_INSTANCE);
    }

    public static EvaluationResult withError(Diagnostic diag) {
        return new EvaluationResult(null, diag);
    }

    public static EvaluationResult withError(String message) {
        return new EvaluationResult(null, (Diagnostic)new BasicDiagnostic(4, IInterpreter.class.getName(), 0, message, null));
    }

    private EvaluationResult(Object rawValue, Diagnostic status) {
        this.rawValue = rawValue;
        this.status = status;
    }

    @Override
    public Object getValue() {
        return this.rawValue;
    }

    @Override
    public Diagnostic getDiagnostic() {
        return this.status;
    }

    @Override
    public boolean success() {
        return 4 != this.status.getSeverity();
    }

    @Override
    public Collection<EObject> asEObjects() {
        Collection<Object> result = this.rawValue instanceof Collection ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Collection)this.rawValue), EObject.class)) : (this.rawValue instanceof EObject ? Collections.singleton((EObject)this.rawValue) : (this.rawValue != null && this.rawValue.getClass().isArray() ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])((Object[])this.rawValue)), EObject.class)) : Collections.emptySet()));
        return result;
    }

    @Override
    public String asString() {
        if (this.rawValue != null) {
            return String.valueOf(this.rawValue);
        }
        return "";
    }
}

