/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.business.api.refresh.DiagramCreationUtil;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class CollapseSupportOnRegionMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    private static final Version MIGRATION_VERSION = new Version("10.0.0.201505131200");

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    protected void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        if (loadedVersion.compareTo(MIGRATION_VERSION) < 0) {
            EClass drawerStyleClass = NotationPackage.eINSTANCE.getDrawerStyle();
            LinkedHashSet allViewsToUpdate = Sets.newLinkedHashSet();
            for (DView dView : dAnalysis.getOwnedViews()) {
                for (DDiagram dDiagram : Iterables.filter((Iterable)dView.getOwnedRepresentations(), DDiagram.class)) {
                    DiagramCreationUtil diagramCreationUtil = new DiagramCreationUtil(dDiagram);
                    if (!diagramCreationUtil.findAssociatedGMFDiagram()) continue;
                    Diagram gmfDiagram = diagramCreationUtil.getAssociatedGMFDiagram();
                    for (Node node : Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.filter((Iterator)gmfDiagram.eAllContents(), Node.class), (Predicate)new IsRegionCompartmentPredicate()))) {
                        Style style = node.getStyle(drawerStyleClass);
                        if (style != null) continue;
                        allViewsToUpdate.add(node);
                    }
                }
            }
            for (View viewToUpdate : allViewsToUpdate) {
                DrawerStyle style = (DrawerStyle)drawerStyleClass.getEPackage().getEFactoryInstance().create(drawerStyleClass);
                style.setCollapsed(false);
                viewToUpdate.getStyles().add((Object)style);
            }
        }
    }

    private class IsRegionCompartmentPredicate
    implements Predicate<Node> {
        private IsRegionCompartmentPredicate() {
        }

        public boolean apply(Node node) {
            int id = SiriusVisualIDRegistry.getVisualID(node.getType());
            if (id == 7002 || id == 7003) {
                EObject element = node.getElement();
                return element instanceof DDiagramElementContainer && new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)element).isRegion();
            }
            return false;
        }
    }
}

