/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.repair;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.migration.IDiagramIdentifierProvider;
import org.eclipse.sirius.viewpoint.Customizable;

public final class Identifier {
    public static final Identifier EMPTY_ID = new Identifier("");
    private static final String PROVIDERS_ID = "org.eclipse.sirius.diagram.ui.diagramIdentifierProvider";
    private static final String PROVIDERS_ATTRIBUTE = "providerClass";
    private static final String TARGET = "target";
    private static List<IDiagramIdentifierProvider> allProviders;
    private String identifier;

    private Identifier(String identifier) {
        this.identifier = identifier;
    }

    private Identifier(StringBuilder identifier) {
        this(identifier.toString());
    }

    public static Identifier createIdentifier(DDiagramElement element) {
        Identifier result = EMPTY_ID;
        String id = Identifier.getId(element);
        if (id != null) {
            result = new Identifier(id);
        }
        return result;
    }

    private static String getId(DDiagramElement element) {
        String id = null;
        if (element instanceof DEdge) {
            id = Identifier.getEdgeId((DEdge)element);
        } else if (element instanceof AbstractDNode) {
            id = Identifier.getNodeId((AbstractDNode)element);
        }
        return id;
    }

    private static String getEdgeId(DEdge edge) {
        StringBuilder buffer = new StringBuilder();
        if (edge != null && !Identifier.identifierFromExtensions((DDiagramElement)edge, buffer)) {
            Identifier.createDiagramIdentifier(edge.getParentDiagram(), buffer);
            if (edge.getSourceNode() instanceof AbstractDNode) {
                Identifier.createNodeIdentifier((AbstractDNode)edge.getSourceNode(), buffer);
            } else if (edge.getSourceNode() instanceof DEdge) {
                Identifier.createEdgeIdentifier((DEdge)edge.getSourceNode(), buffer);
            }
            if (edge.getTargetNode() instanceof AbstractDNode) {
                Identifier.createNodeIdentifier((AbstractDNode)edge.getTargetNode(), buffer);
            } else if (edge.getTargetNode() instanceof DEdge) {
                Identifier.createEdgeIdentifier((DEdge)edge.getTargetNode(), buffer);
            }
            Identifier.checkNotNull(edge.getTarget(), TARGET);
            buffer.append(EcoreUtil.getURI((EObject)edge.getTarget()));
            Identifier.checkNotNull(edge.getActualMapping(), "actualMapping");
            buffer.append(EcoreUtil.getURI((EObject)edge.getActualMapping()));
        }
        return buffer.toString();
    }

    private static String getNodeId(AbstractDNode node) {
        StringBuilder sb = new StringBuilder();
        if (node != null) {
            Identifier.createDiagramIdentifier(node.getParentDiagram(), sb);
            Identifier.createNodeIdentifier(node, sb);
        }
        return sb.toString();
    }

    private static void createNodeIdentifier(AbstractDNode node, StringBuilder buffer) {
        if (node != null && !Identifier.identifierFromExtensions((DDiagramElement)node, buffer)) {
            if (node.eContainer() instanceof AbstractDNode) {
                Identifier.createNodeIdentifier((AbstractDNode)node.eContainer(), buffer);
            }
            Identifier.checkNotNull(node.getTarget(), TARGET);
            buffer.append(EcoreUtil.getURI((EObject)node.getTarget()));
            Identifier.checkNotNull(node.getMapping(), "mapping");
            buffer.append(EcoreUtil.getURI((EObject)node.getMapping()));
        }
    }

    private static void createEdgeIdentifier(DEdge edge, StringBuilder buffer) {
        if (edge != null && !Identifier.identifierFromExtensions((DDiagramElement)edge, buffer)) {
            Identifier.checkNotNull(edge.getTarget(), TARGET);
            buffer.append(EcoreUtil.getURI((EObject)edge.getTarget()));
            Identifier.checkNotNull(edge.getMapping(), "mapping");
            buffer.append(EcoreUtil.getURI((EObject)edge.getMapping()));
        }
    }

    private static void createDiagramIdentifier(DDiagram diagram, StringBuilder buffer) {
        buffer.append(EcoreUtil.getURI((EObject)diagram));
    }

    public static Identifier createCustomizableIdentifier(Customizable customizable) {
        Object list;
        StringBuilder sb = new StringBuilder();
        DDiagramElement dDiagramElement = Identifier.getDDiagramElement(customizable);
        String id = Identifier.getId(dDiagramElement);
        if (id != null) {
            sb.append(id);
        }
        if (!(customizable.eContainer() instanceof DDiagramElement)) {
            EObject eContainer = customizable.eContainer();
            sb.append("." + eContainer.eContainingFeature().getName() + ".");
        }
        sb.append(customizable.eContainingFeature().getName());
        if (customizable.eContainingFeature().isMany() && (list = customizable.eContainer().eGet(customizable.eContainingFeature())) instanceof List) {
            List values = (List)list;
            sb.append("[" + values.indexOf(customizable) + "]");
        }
        return new Identifier(sb);
    }

    private static DDiagramElement getDDiagramElement(Customizable customizable) {
        DDiagramElement dDiagramElement = null;
        EObject container = customizable.eContainer();
        while (!(container instanceof DDiagramElement) && container != null) {
            container = container.eContainer();
        }
        if (container instanceof DDiagramElement) {
            dDiagramElement = (DDiagramElement)container;
        }
        return dDiagramElement;
    }

    private static void checkNotNull(Object obj, String propertyName) {
        if (obj == null) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.Identifier_invalidNullObject, propertyName));
        }
    }

    private static boolean identifierFromExtensions(DDiagramElement element, StringBuilder buffer) {
        for (IDiagramIdentifierProvider identifierProvider : Identifier.getAllProviders()) {
            if (!identifierProvider.provides(element)) continue;
            String string = identifierProvider.computeIdentifier(element);
            buffer.append(string);
            return true;
        }
        return false;
    }

    private static List<IDiagramIdentifierProvider> getAllProviders() {
        if (allProviders == null) {
            allProviders = EclipseUtil.getExtensionPlugins(IDiagramIdentifierProvider.class, (String)PROVIDERS_ID, (String)PROVIDERS_ATTRIBUTE);
        }
        return allProviders;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    public String toString() {
        return "id: " + this.identifier;
    }
}

