/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.CreateRepresentationFromRepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;

public class SubDiagramMenu
implements IContributionItemProvider {
    private static final String CREATE_REPRESENTATION_GROUP_SEPARATOR = "createRepresentationGroup";
    private static final String MENU_NEW_REPRESENTATION_ID = "popup.new";

    public void contributeToActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void contributeToPopupMenu(IMenuManager menu, IWorkbenchPart part) {
        SiriusDiagramEditor diagrampart;
        EditPart editpart;
        if (part instanceof SiriusDiagramEditor && (editpart = (diagrampart = (SiriusDiagramEditor)part).getDiagramGraphicalViewer().getFocusEditPart()) instanceof IGraphicalEditPart && !(editpart instanceof NoteEditPart)) {
            EObject target;
            IGraphicalEditPart curPart = (IGraphicalEditPart)editpart;
            EObject eObj = curPart.resolveSemanticElement();
            if (eObj instanceof DRepresentationElement && ((target = ((DRepresentationElement)eObj).getTarget()) == null || target.eResource() == null)) {
                return;
            }
            if (editpart instanceof ISiriusEditPart) {
                MenuManager newMenuManager = new MenuManager(Messages.SubDiagramMenu_newLabel, MENU_NEW_REPRESENTATION_ID);
                if (!menu.isEmpty()) {
                    menu.insertBefore(menu.getItems()[0].getId(), (IContributionItem)newMenuManager);
                } else {
                    menu.add((IContributionItem)newMenuManager);
                }
                Separator createGroup = new Separator(CREATE_REPRESENTATION_GROUP_SEPARATOR);
                newMenuManager.add((IContributionItem)createGroup);
                if (eObj instanceof DDiagramElement) {
                    this.createDetailsActions((DDiagramElement)eObj, (IMenuManager)newMenuManager, diagrampart.getEditingDomain(), curPart);
                }
            }
        }
    }

    private boolean isFromActiveViewpoint(Session session, RepresentationDescription description) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(description);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    private void createDetailsActions(DDiagramElement dde, IMenuManager newMenu, TransactionalEditingDomain editingDomain, IGraphicalEditPart curPart) {
        if (dde.getMapping() != null) {
            Session session;
            EObject sessionFinder = null;
            EList semanticElements = dde.getSemanticElements();
            if (semanticElements != null && !semanticElements.isEmpty()) {
                sessionFinder = (EObject)semanticElements.get(0);
            } else if (dde.getTarget() != null) {
                sessionFinder = dde.getTarget();
            }
            Session session2 = session = sessionFinder != null ? SessionManager.INSTANCE.getSession(sessionFinder) : null;
            if (session != null) {
                for (RepresentationCreationDescription desc : dde.getMapping().getDetailDescriptions()) {
                    boolean append = true;
                    if (!this.isFromActiveViewpoint(session, desc.getRepresentationDescription())) {
                        append = false;
                    }
                    String precondition = desc.getPrecondition();
                    if (append && !StringUtil.isEmpty((String)precondition)) {
                        append = false;
                        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)dde);
                        try {
                            append = interpreter.evaluateBoolean(dde.getTarget(), precondition);
                        }
                        catch (EvaluationException evaluationException) {}
                    }
                    if (!append) continue;
                    newMenu.appendToGroup(CREATE_REPRESENTATION_GROUP_SEPARATOR, (IAction)new CreateRepresentationFromRepresentationCreationDescription(desc, (DRepresentationElement)dde, editingDomain, curPart));
                }
            }
        }
    }

    public void disposeContributions(IWorkbenchPartDescriptor arg0) {
    }

    public void updateActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void addProviderChangeListener(IProviderChangeListener arg0) {
    }

    public boolean provides(IOperation arg0) {
        return true;
    }

    public void removeProviderChangeListener(IProviderChangeListener arg0) {
    }
}

