/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.color;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.color.AbstractColorUpdater;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public class DiagramStyleColorUpdater
extends AbstractColorUpdater {
    private BiMap<EReference, EAttribute> descToStyleForColorFeatures = HashBiMap.create();

    public DiagramStyleColorUpdater() {
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getBorderedStyleDescription_BorderColor(), (Object)DiagramPackage.eINSTANCE.getBorderedStyle_BorderColor());
        this.descToStyleForColorFeatures.put((Object)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelColor(), (Object)ViewpointPackage.eINSTANCE.getBasicLabelStyle_LabelColor());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getBundledImageDescription_Color(), (Object)DiagramPackage.eINSTANCE.getBundledImage_Color());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getDotDescription_BackgroundColor(), (Object)DiagramPackage.eINSTANCE.getDot_BackgroundColor());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getEdgeStyleDescription_StrokeColor(), (Object)DiagramPackage.eINSTANCE.getEdgeStyle_StrokeColor());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getEllipseNodeDescription_Color(), (Object)DiagramPackage.eINSTANCE.getEllipse_Color());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getFlatContainerStyleDescription_BackgroundColor(), (Object)DiagramPackage.eINSTANCE.getFlatContainerStyle_BackgroundColor());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getFlatContainerStyleDescription_ForegroundColor(), (Object)DiagramPackage.eINSTANCE.getFlatContainerStyle_ForegroundColor());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getGaugeSectionDescription_BackgroundColor(), (Object)DiagramPackage.eINSTANCE.getGaugeSection_BackgroundColor());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getGaugeSectionDescription_ForegroundColor(), (Object)DiagramPackage.eINSTANCE.getGaugeSection_ForegroundColor());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getLozengeNodeDescription_Color(), (Object)DiagramPackage.eINSTANCE.getLozenge_Color());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getNoteDescription_Color(), (Object)DiagramPackage.eINSTANCE.getNote_Color());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getSquareDescription_Color(), (Object)DiagramPackage.eINSTANCE.getSquare_Color());
        this.descToStyleForColorFeatures.put((Object)org.eclipse.sirius.diagram.description.style.StylePackage.eINSTANCE.getShapeContainerStyleDescription_BackgroundColor(), (Object)DiagramPackage.eINSTANCE.getShapeContainerStyle_BackgroundColor());
    }

    public void updateColors(EObject context, Customizable style, EObject description, Option<? extends Customizable> previousStyle) {
        this.updateColorReflectively(context, style, description, previousStyle);
    }

    private void updateColorReflectively(EObject context, Customizable style, EObject description, Option<? extends Customizable> previousStyle) {
        List<EAttribute> eAllReferences = this.getAllStyleReferences((EObject)style);
        for (EAttribute feature : eAllReferences) {
            EStructuralFeature eStructuralFeature;
            if (!this.descToStyleForColorFeatures.containsValue((Object)feature) || description == null) continue;
            if (previousStyle.some() && ((Customizable)previousStyle.get()).getCustomFeatures().contains((Object)feature.getName()) && (eStructuralFeature = ((Customizable)previousStyle.get()).eClass().getEStructuralFeature(feature.getName())) != null && eStructuralFeature.getEType() == feature.getEType()) {
                Object customValue = ((Customizable)previousStyle.get()).eGet(eStructuralFeature);
                style.eSet((EStructuralFeature)feature, customValue);
                style.getCustomFeatures().add((Object)feature.getName());
            }
            if (style.getCustomFeatures().contains((Object)feature.getName())) continue;
            this.updateNotCustomFeatureReflectively(context, style, description, feature);
        }
    }

    private void updateNotCustomFeatureReflectively(EObject context, Customizable style, EObject description, EAttribute feature) {
        Object descValue = description.eGet((EStructuralFeature)this.descToStyleForColorFeatures.inverse().get((Object)feature));
        if (descValue instanceof ColorDescription) {
            RGBValues newValues = this.getRGBValuesFromColorDescription(context, (ColorDescription)descValue);
            style.eSet((EStructuralFeature)feature, (Object)newValues);
        }
    }

    private List<EAttribute> getAllStyleReferences(EObject style) {
        ArrayList eAllReferences = Lists.newArrayList();
        EList styleReferences = style.eClass().getEAllAttributes();
        eAllReferences.addAll(styleReferences);
        return eAllReferences;
    }

    public void updateColors(Style style, StyleDescription description, Option<? extends Customizable> previousStyle) {
        this.updateColorReflectively(null, (Customizable)style, (EObject)description, previousStyle);
    }

    public void updateColors(BasicLabelStyle style, BasicLabelStyleDescription description, Option<? extends Customizable> previousStyle) {
        this.updateColorReflectively(null, (Customizable)style, (EObject)description, previousStyle);
    }
}

