/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BeginLabelStyle;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.BundledImageShape;
import org.eclipse.sirius.diagram.CenterLabelStyle;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.CustomStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.Dot;
import org.eclipse.sirius.diagram.EdgeRouting;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.Ellipse;
import org.eclipse.sirius.diagram.EndLabelStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.GaugeCompositeStyle;
import org.eclipse.sirius.diagram.GaugeSection;
import org.eclipse.sirius.diagram.HideLabelCapabilityStyle;
import org.eclipse.sirius.diagram.Lozenge;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.Note;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.color.DiagramStyleColorUpdater;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.style.BeginLabelStyleDescription;
import org.eclipse.sirius.diagram.description.style.BorderedStyleDescription;
import org.eclipse.sirius.diagram.description.style.BracketEdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.BundledImageDescription;
import org.eclipse.sirius.diagram.description.style.CenterLabelStyleDescription;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.CustomStyleDescription;
import org.eclipse.sirius.diagram.description.style.DotDescription;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.EllipseNodeDescription;
import org.eclipse.sirius.diagram.description.style.EndLabelStyleDescription;
import org.eclipse.sirius.diagram.description.style.FlatContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.GaugeCompositeStyleDescription;
import org.eclipse.sirius.diagram.description.style.GaugeSectionDescription;
import org.eclipse.sirius.diagram.description.style.HideLabelCapabilityStyleDescription;
import org.eclipse.sirius.diagram.description.style.LozengeNodeDescription;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.NoteDescription;
import org.eclipse.sirius.diagram.description.style.ShapeContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.SizeComputationContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.SquareDescription;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.util.DiagramSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.LabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public final class StyleHelper {
    private static final Integer DEFAULT_SIZE = 3;
    private static final Integer AUTO_SIZE_CONTAINER = -1;
    private IInterpreter interpreter;
    private DiagramStyleColorUpdater colorUpdater;

    public StyleHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
        this.colorUpdater = new DiagramStyleColorUpdater();
    }

    public void refreshStyle(Style style) {
        this.refreshStyle(style, (Option<? extends Style>)Options.newSome((Object)style));
    }

    public void refreshStyle(Style style, Option<? extends Style> previousStyle) {
        if (style != null && !this.isWorkspaceImageStyleWithNotWorkspaceImageDescription(style)) {
            StyleDescription description = style.getDescription();
            if (description instanceof ContainerStyleDescription && style instanceof ContainerStyle) {
                this.updateContainerStyle((ContainerStyleDescription)description, (ContainerStyle)style, previousStyle);
            }
            if (description instanceof NodeStyleDescription && style instanceof NodeStyle) {
                this.updateNodeStyle((NodeStyleDescription)description, (NodeStyle)style, previousStyle);
            }
            if (description instanceof EdgeStyleDescription) {
                this.updateEdgeStyle((EdgeStyleDescription)description, (EdgeStyle)style, previousStyle);
            }
            this.refreshColors(style, previousStyle);
        }
    }

    private boolean isWorkspaceImageStyleWithNotWorkspaceImageDescription(Style style) {
        boolean isWorkspaceImageStyleWithNotWorkspaceImageDescription = style instanceof WorkspaceImage && !(style.getDescription() instanceof WorkspaceImageDescription) && !style.getCustomFeatures().isEmpty();
        return isWorkspaceImageStyleWithNotWorkspaceImageDescription;
    }

    public Style createStyle(StyleDescription description) {
        Style style = null;
        if (description instanceof ContainerStyleDescription) {
            style = this.createContainerStyle((ContainerStyleDescription)description);
        } else if (description instanceof NodeStyleDescription) {
            style = this.createNodeStyle((NodeStyleDescription)description);
        } else if (description instanceof EdgeStyleDescription) {
            style = this.createEdgeStyle((EdgeStyleDescription)description);
        }
        return style;
    }

    public EdgeStyle createEdgeStyle(EdgeStyleDescription description) {
        EdgeStyle style = null;
        style = description instanceof BracketEdgeStyleDescription ? DiagramFactory.eINSTANCE.createBracketEdgeStyle() : DiagramFactory.eINSTANCE.createEdgeStyle();
        if (description.getBeginLabelStyleDescription() != null) {
            style.setBeginLabelStyle(DiagramFactory.eINSTANCE.createBeginLabelStyle());
        }
        if (description.getEndLabelStyleDescription() != null) {
            style.setEndLabelStyle(DiagramFactory.eINSTANCE.createEndLabelStyle());
        }
        if (description.getCenterLabelStyleDescription() != null) {
            style.setCenterLabelStyle(DiagramFactory.eINSTANCE.createCenterLabelStyle());
        }
        Option noPreviousStyle = Options.newNone();
        this.updateEdgeStyle(description, style, (Option<EdgeStyle>)noPreviousStyle);
        this.refreshColors(style, (Option<? extends Style>)noPreviousStyle);
        return style;
    }

    private void updateEdgeStyle(EdgeStyleDescription edgeDescription, EdgeStyle edgeStyle, Option<EdgeStyle> previousStyle) {
        Integer size = 1;
        if (edgeStyle.getDescription() != edgeDescription) {
            edgeStyle.setDescription(edgeDescription);
        }
        if (edgeDescription != null) {
            if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__SOURCE_ARROW.getName())) {
                edgeStyle.setSourceArrow(((EdgeStyle)previousStyle.get()).getSourceArrow());
                edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__SOURCE_ARROW.getName());
            } else if (edgeStyle.getSourceArrow().getValue() != edgeDescription.getSourceArrow().getValue() && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__SOURCE_ARROW.getName())) {
                edgeStyle.setSourceArrow(edgeDescription.getSourceArrow());
            }
            if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__TARGET_ARROW.getName())) {
                edgeStyle.setTargetArrow(((EdgeStyle)previousStyle.get()).getTargetArrow());
                edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__TARGET_ARROW.getName());
            } else if (edgeStyle.getTargetArrow().getValue() != edgeDescription.getTargetArrow().getValue() && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__TARGET_ARROW.getName())) {
                edgeStyle.setTargetArrow(edgeDescription.getTargetArrow());
            }
            if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__LINE_STYLE.getName())) {
                edgeStyle.setLineStyle(((EdgeStyle)previousStyle.get()).getLineStyle());
                edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__LINE_STYLE.getName());
            } else if (edgeStyle.getLineStyle().getValue() != edgeDescription.getLineStyle().getValue() && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__LINE_STYLE.getName())) {
                edgeStyle.setLineStyle(edgeDescription.getLineStyle());
            }
            if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__FOLDING_STYLE.getName())) {
                edgeStyle.setFoldingStyle(((EdgeStyle)previousStyle.get()).getFoldingStyle());
                edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__FOLDING_STYLE.getName());
            } else if (edgeStyle.getFoldingStyle().getValue() != edgeDescription.getFoldingStyle().getValue() && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__FOLDING_STYLE.getName())) {
                edgeStyle.setFoldingStyle(edgeDescription.getFoldingStyle());
            }
            if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__SIZE.getName())) {
                edgeStyle.setSize(((EdgeStyle)previousStyle.get()).getSize());
                edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__SIZE.getName());
            } else if (edgeDescription.getSizeComputationExpression() != null && edgeStyle.eContainer() != null && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__SIZE.getName())) {
                try {
                    size = this.interpreter.evaluateInteger(((DSemanticDecorator)edgeStyle.eContainer()).getTarget(), edgeDescription.getSizeComputationExpression());
                }
                catch (EvaluationException evaluationException) {}
                edgeStyle.setSize(size);
            }
            IPreferencesService service = Platform.getPreferencesService();
            Option overrideEdgeRouting = Options.newNone();
            boolean isOverideEnabled = service.getBoolean("org.eclipse.sirius.diagram", "Viewpoint.Connectors.enableOverride", false, null);
            if (isOverideEnabled) {
                int routingStyle = service.getInt("org.eclipse.sirius.diagram", "Viewpoint.Connectors.lineStyle", 0, null);
                overrideEdgeRouting = Options.newSome((Object)((Object)EdgeRouting.get(routingStyle)));
            }
            if (previousStyle.some()) {
                if (((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName())) {
                    edgeStyle.setRoutingStyle(((EdgeStyle)previousStyle.get()).getRoutingStyle());
                    edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName());
                }
            } else if (overrideEdgeRouting.some()) {
                edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName());
                if (edgeStyle.getRoutingStyle().getValue() != ((EdgeRouting)((Object)overrideEdgeRouting.get())).getValue()) {
                    edgeStyle.setRoutingStyle((EdgeRouting)((Object)overrideEdgeRouting.get()));
                }
            }
            if (edgeDescription.getRoutingStyle().getValue() != edgeStyle.getRoutingStyle().getValue() && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__ROUTING_STYLE.getName())) {
                edgeStyle.setRoutingStyle(edgeDescription.getRoutingStyle());
            }
            this.updateLabels(edgeDescription, edgeStyle, previousStyle);
            this.updateEdgeCenteringInformations(edgeDescription, edgeStyle, previousStyle);
        }
    }

    private void updateLabels(EdgeStyleDescription edgeDescription, EdgeStyle edgeStyle, Option<EdgeStyle> previousStyle) {
        if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__CENTER_LABEL_STYLE.getName())) {
            edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__CENTER_LABEL_STYLE.getName());
            edgeStyle.setCenterLabelStyle(((EdgeStyle)previousStyle.get()).getCenterLabelStyle());
        }
        if (edgeDescription.getCenterLabelStyleDescription() != null && edgeStyle.getCenterLabelStyle() == null && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__CENTER_LABEL_STYLE.getName())) {
            CenterLabelStyle centerLabelStyle = DiagramFactory.eINSTANCE.createCenterLabelStyle();
            edgeStyle.setCenterLabelStyle(centerLabelStyle);
        }
        this.updateEdgeLabel(edgeDescription.getCenterLabelStyleDescription(), edgeStyle.getCenterLabelStyle());
        if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__BEGIN_LABEL_STYLE.getName())) {
            edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__BEGIN_LABEL_STYLE.getName());
            edgeStyle.setBeginLabelStyle(((EdgeStyle)previousStyle.get()).getBeginLabelStyle());
        }
        if (edgeDescription.getBeginLabelStyleDescription() != null && edgeStyle.getBeginLabelStyle() == null && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__BEGIN_LABEL_STYLE.getName())) {
            BeginLabelStyle beginLabelStyle = DiagramFactory.eINSTANCE.createBeginLabelStyle();
            edgeStyle.setBeginLabelStyle(beginLabelStyle);
        }
        this.updateEdgeLabel(edgeDescription.getBeginLabelStyleDescription(), edgeStyle.getBeginLabelStyle());
        if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__END_LABEL_STYLE.getName())) {
            edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__END_LABEL_STYLE.getName());
            edgeStyle.setBeginLabelStyle(((EdgeStyle)previousStyle.get()).getBeginLabelStyle());
        }
        if (edgeDescription.getEndLabelStyleDescription() != null && edgeStyle.getEndLabelStyle() == null && !edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__END_LABEL_STYLE.getName())) {
            EndLabelStyle endLabelStyle = DiagramFactory.eINSTANCE.createEndLabelStyle();
            edgeStyle.setEndLabelStyle(endLabelStyle);
        }
        this.updateEdgeLabel(edgeDescription.getEndLabelStyleDescription(), edgeStyle.getEndLabelStyle());
    }

    private void updateEdgeCenteringInformations(EdgeStyleDescription edgeDescription, EdgeStyle edgeStyle, Option<EdgeStyle> previousStyle) {
        if (previousStyle.some() && ((EdgeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__CENTERED.getName())) {
            edgeStyle.setCentered(((EdgeStyle)previousStyle.get()).getCentered());
            edgeStyle.getCustomFeatures().add((Object)DiagramPackage.Literals.EDGE_STYLE__CENTERED.getName());
        } else if (!edgeStyle.getCustomFeatures().contains((Object)DiagramPackage.Literals.EDGE_STYLE__CENTERED.getName())) {
            this.computeCentered(edgeDescription, edgeStyle);
        }
    }

    private void computeCentered(EdgeStyleDescription edgeDescription, EdgeStyle edgeStyle) {
        switch (edgeDescription.getEndsCentering().getValue()) {
            case 1: {
                edgeStyle.setCentered(CenteringStyle.BOTH);
                break;
            }
            case 2: {
                if (this.isTargetCentered(edgeDescription, edgeStyle)) {
                    edgeStyle.setCentered(CenteringStyle.BOTH);
                    break;
                }
                edgeStyle.setCentered(CenteringStyle.SOURCE);
                break;
            }
            case 3: {
                if (this.isSourceCentered(edgeDescription, edgeStyle)) {
                    edgeStyle.setCentered(CenteringStyle.BOTH);
                    break;
                }
                edgeStyle.setCentered(CenteringStyle.TARGET);
                break;
            }
            case 0: {
                boolean isSourceCentered = this.isSourceCentered(edgeDescription, edgeStyle);
                boolean isTargetCentered = this.isTargetCentered(edgeDescription, edgeStyle);
                if (isSourceCentered && isTargetCentered) {
                    edgeStyle.setCentered(CenteringStyle.BOTH);
                    break;
                }
                if (isSourceCentered) {
                    edgeStyle.setCentered(CenteringStyle.SOURCE);
                    break;
                }
                if (isTargetCentered) {
                    edgeStyle.setCentered(CenteringStyle.TARGET);
                    break;
                }
                edgeStyle.setCentered(CenteringStyle.NONE);
                break;
            }
        }
    }

    private boolean isTargetCentered(EdgeStyleDescription edgeDescription, EdgeStyle edgeStyle) {
        EdgeTarget edgeTarget;
        EObject dEdgeEObject = edgeStyle.eContainer();
        if (dEdgeEObject instanceof DEdge && (edgeTarget = ((DEdge)dEdgeEObject).getTargetNode()) instanceof DDiagramElement) {
            EList<DiagramElementMapping> centeredTargetMappings = edgeDescription.getCenteredTargetMappings();
            return this.isHierarchyPartOfMappingsList(edgeTarget, (List<DiagramElementMapping>)centeredTargetMappings);
        }
        return false;
    }

    private boolean isSourceCentered(EdgeStyleDescription edgeDescription, EdgeStyle edgeStyle) {
        EdgeTarget edgeSource;
        EObject dEdgeEObject = edgeStyle.eContainer();
        if (dEdgeEObject instanceof DEdge && (edgeSource = ((DEdge)dEdgeEObject).getSourceNode()) instanceof DDiagramElement) {
            EList<DiagramElementMapping> centeredSourceMappings = edgeDescription.getCenteredSourceMappings();
            return this.isHierarchyPartOfMappingsList(edgeSource, (List<DiagramElementMapping>)centeredSourceMappings);
        }
        return false;
    }

    private boolean isHierarchyPartOfMappingsList(EdgeTarget edgeTarget, List<DiagramElementMapping> mappingsList) {
        DiagramElementMapping diagramElementMapping = ((DDiagramElement)((Object)edgeTarget)).getDiagramElementMapping();
        DiagramElementMappingQuery mappingQuery = new DiagramElementMappingQuery(diagramElementMapping);
        for (DiagramElementMapping currentMapping : mappingsList) {
            if (!EqualityHelper.areEquals((EObject)diagramElementMapping, (EObject)currentMapping) && !mappingQuery.isSubTypeOf(currentMapping)) continue;
            return true;
        }
        return false;
    }

    private void updateEdgeLabel(BasicLabelStyleDescription description, BasicLabelStyle style) {
        if (description instanceof BeginLabelStyleDescription && style instanceof BeginLabelStyle && ((BeginLabelStyle)style).getDescription() != description) {
            ((BeginLabelStyle)style).setDescription(description);
        }
        if (description instanceof EndLabelStyleDescription && style instanceof EndLabelStyle && ((EndLabelStyle)style).getDescription() != description) {
            ((EndLabelStyle)style).setDescription(description);
        }
        if (description instanceof CenterLabelStyleDescription && style instanceof CenterLabelStyle && ((CenterLabelStyle)style).getDescription() != description) {
            ((CenterLabelStyle)style).setDescription(description);
        }
        if (description != null && style != null) {
            if (style.isShowIcon() != description.isShowIcon() && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON.getName())) {
                style.setShowIcon(description.isShowIcon());
            }
            if (style.getIconPath() != null && !style.getIconPath().equals(description.getIconPath()) && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH.getName())) {
                style.setIconPath(description.getIconPath());
            }
            Option noPreviousStyle = Options.newNone();
            this.updateBasicLabelStyleFeatures(description, style, (Option<? extends BasicLabelStyle>)noPreviousStyle);
        }
    }

    private void updateLabelStyleFeatures(LabelStyleDescription description, LabelStyle style, Option<? extends LabelStyle> previousStyle) {
        LabelAlignment alignment = description.getLabelAlignment();
        if (previousStyle.some() && ((LabelStyle)previousStyle.get()).getCustomFeatures().contains((Object)ViewpointPackage.Literals.LABEL_STYLE__LABEL_ALIGNMENT.getName())) {
            style.setLabelAlignment(((LabelStyle)previousStyle.get()).getLabelAlignment());
            style.getCustomFeatures().add((Object)ViewpointPackage.Literals.LABEL_STYLE__LABEL_ALIGNMENT.getName());
        } else if (style.getLabelAlignment() != alignment && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.LABEL_STYLE__LABEL_ALIGNMENT.getName())) {
            style.setLabelAlignment(alignment);
        }
        this.updateBasicLabelStyleFeatures((BasicLabelStyleDescription)description, (BasicLabelStyle)style, previousStyle);
    }

    private void updateBasicLabelStyleFeatures(BasicLabelStyleDescription description, BasicLabelStyle style, Option<? extends BasicLabelStyle> previousStyle) {
        EList format = description.getLabelFormat();
        int size = description.getLabelSize();
        if (previousStyle.some() && ((BasicLabelStyle)previousStyle.get()).getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON.getName())) {
            style.setShowIcon(((BasicLabelStyle)previousStyle.get()).isShowIcon());
            style.getCustomFeatures().add((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON.getName());
        } else if (style.isShowIcon() != description.isShowIcon() && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON.getName())) {
            style.setShowIcon(description.isShowIcon());
        }
        if (previousStyle.some() && ((BasicLabelStyle)previousStyle.get()).getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH.getName())) {
            style.setIconPath(((BasicLabelStyle)previousStyle.get()).getIconPath());
            style.getCustomFeatures().add((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH.getName());
        } else if (style.getIconPath() != null && !style.getIconPath().equals(description.getIconPath()) && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH.getName())) {
            style.setIconPath(description.getIconPath());
        }
        if (previousStyle.some() && ((BasicLabelStyle)previousStyle.get()).getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName())) {
            FontFormatHelper.setFontFormat((List)style.getLabelFormat(), (Collection)((BasicLabelStyle)previousStyle.get()).getLabelFormat());
            style.getCustomFeatures().add((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName());
        } else if (!style.getLabelFormat().equals((Object)format) && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName())) {
            FontFormatHelper.setFontFormat((List)style.getLabelFormat(), (Collection)format);
        }
        if (previousStyle.some() && ((BasicLabelStyle)previousStyle.get()).getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE.getName())) {
            style.setLabelSize(Math.max(((BasicLabelStyle)previousStyle.get()).getLabelSize(), 1));
            style.getCustomFeatures().add((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE.getName());
        } else if (style.getLabelSize() != size && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE.getName())) {
            style.setLabelSize(Math.max(size, 1));
        }
    }

    public ContainerStyle createContainerStyle(ContainerStyleDescription description) {
        ContainerStyle style = null;
        if (description instanceof FlatContainerStyleDescription) {
            style = this.createFlatContainerStyle((FlatContainerStyleDescription)description);
        } else if (description instanceof ShapeContainerStyleDescription) {
            style = this.createShapeContainerStyle((ShapeContainerStyleDescription)description);
        } else if (description instanceof WorkspaceImageDescription) {
            style = this.createWorkspaceImage((WorkspaceImageDescription)description);
        }
        if (style != null) {
            style.setHideLabelByDefault(description.isHideLabelByDefault());
            Option noPreviousStyle = Options.newNone();
            this.refreshColors(style, (Option<? extends Style>)noPreviousStyle);
        }
        return style;
    }

    private void updateContainerStyle(ContainerStyleDescription description, ContainerStyle style, Option<? extends Style> previousStyle) {
        if (previousStyle.some() && ((Style)previousStyle.get()).getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON.getName())) {
            if (previousStyle.get() instanceof BasicLabelStyle) {
                style.setShowIcon(((BasicLabelStyle)previousStyle.get()).isShowIcon());
            }
            style.getCustomFeatures().add((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON.getName());
        } else if (style.isShowIcon() != description.isShowIcon() && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON.getName())) {
            style.setShowIcon(description.isShowIcon());
        }
        if (previousStyle.some() && ((Style)previousStyle.get()).getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH.getName())) {
            if (previousStyle.get() instanceof BasicLabelStyle) {
                style.setIconPath(((BasicLabelStyle)previousStyle.get()).getIconPath());
            }
            style.getCustomFeatures().add((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH.getName());
        } else if (style.getIconPath() != null && !style.getIconPath().equals(description.getIconPath()) && !style.getCustomFeatures().contains((Object)ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH.getName())) {
            style.setIconPath(description.getIconPath());
        }
        if (description instanceof FlatContainerStyleDescription && style instanceof FlatContainerStyle) {
            this.updateFlatContainerStyle((FlatContainerStyle)style, (FlatContainerStyleDescription)description, previousStyle);
        } else if (description instanceof ShapeContainerStyleDescription && style instanceof ShapeContainerStyle) {
            this.updateShapeContainerStyle((ShapeContainerStyle)style, (ShapeContainerStyleDescription)description, previousStyle);
        } else if (description instanceof WorkspaceImageDescription && style instanceof WorkspaceImage) {
            this.updateWorkspaceImage((WorkspaceImage)style, (WorkspaceImageDescription)description, previousStyle);
        }
        if (previousStyle.get() instanceof BorderedStyle) {
            this.updateBorderedStyleFeatures(description, style, previousStyle);
        } else {
            Option noPreviousBorderedStyle = Options.newNone();
            this.updateBorderedStyleFeatures(description, style, (Option<BorderedStyle>)noPreviousBorderedStyle);
        }
        this.updateHideLabelCapabilityFeature(description, style, previousStyle);
    }

    private void updateHideLabelCapabilityFeature(HideLabelCapabilityStyleDescription description, HideLabelCapabilityStyle style, Option<? extends Style> previousStyle) {
        if (previousStyle.some() && ((Style)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.HIDE_LABEL_CAPABILITY_STYLE__HIDE_LABEL_BY_DEFAULT.getName())) {
            if (previousStyle.get() instanceof HideLabelCapabilityStyle) {
                style.setHideLabelByDefault(((HideLabelCapabilityStyle)previousStyle.get()).isHideLabelByDefault());
            }
            if (style instanceof Customizable) {
                ((Customizable)style).getCustomFeatures().add((Object)DiagramPackage.Literals.HIDE_LABEL_CAPABILITY_STYLE__HIDE_LABEL_BY_DEFAULT.getName());
            }
        } else if (style instanceof Customizable && !((Customizable)style).getCustomFeatures().contains((Object)DiagramPackage.Literals.HIDE_LABEL_CAPABILITY_STYLE__HIDE_LABEL_BY_DEFAULT.getName())) {
            style.setHideLabelByDefault(description.isHideLabelByDefault());
        }
    }

    public NodeStyle createNodeStyle(NodeStyleDescription description) {
        NodeStyle style = null;
        if (description instanceof CustomStyleDescription) {
            style = this.createCustomStyle((CustomStyleDescription)description);
        } else if (description instanceof SquareDescription) {
            style = this.createSquare((SquareDescription)description);
        } else if (description instanceof DotDescription) {
            style = this.createDot((DotDescription)description);
        } else if (description instanceof GaugeCompositeStyleDescription) {
            style = this.createGaugeCompositeStyle((GaugeCompositeStyleDescription)description);
        } else if (description instanceof NoteDescription) {
            style = this.createNote((NoteDescription)description);
        } else if (description instanceof BundledImageDescription) {
            style = this.createBundledImage((BundledImageDescription)description);
        } else if (description instanceof WorkspaceImageDescription) {
            style = this.createWorkspaceImage((WorkspaceImageDescription)description);
        } else if (description instanceof EllipseNodeDescription) {
            style = this.createEllipse((EllipseNodeDescription)description);
        } else if (description instanceof LozengeNodeDescription) {
            style = this.createLozenge((LozengeNodeDescription)description);
        }
        if (style != null) {
            style.setLabelPosition(description.getLabelPosition());
            style.setHideLabelByDefault(description.isHideLabelByDefault());
            Option noPreviousStyle = Options.newNone();
            this.refreshColors(style, (Option<? extends Style>)noPreviousStyle);
        }
        return style;
    }

    private void updateNodeStyle(NodeStyleDescription description, NodeStyle style, Option<? extends Style> previousStyle) {
        boolean brokenStyle = false;
        if (previousStyle.get() instanceof BasicLabelStyle) {
            this.updateBasicLabelStyleFeatures((BasicLabelStyleDescription)description, (BasicLabelStyle)style, previousStyle);
        } else {
            Option noPreviousBasicLabelStyle = Options.newNone();
            this.updateBasicLabelStyleFeatures((BasicLabelStyleDescription)description, (BasicLabelStyle)style, (Option<? extends BasicLabelStyle>)noPreviousBasicLabelStyle);
        }
        if (description instanceof CustomStyleDescription) {
            if (style instanceof CustomStyle) {
                this.updateCustomStyle((CustomStyle)style, (CustomStyleDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof SquareDescription) {
            if (style instanceof Square) {
                this.updateSquare((Square)style, (SquareDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof DotDescription) {
            if (style instanceof Dot) {
                this.updateDot((Dot)style, (DotDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof GaugeCompositeStyleDescription) {
            if (style instanceof GaugeCompositeStyle) {
                this.updateGaugeCompositeStyle((GaugeCompositeStyle)style, (GaugeCompositeStyleDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof NoteDescription) {
            if (style instanceof Note) {
                this.updateNote((Note)style, (NoteDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof BundledImageDescription) {
            if (style instanceof BundledImage) {
                this.updateBundledImage((BundledImage)style, (BundledImageDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof WorkspaceImageDescription) {
            if (style instanceof WorkspaceImage) {
                this.updateWorkspaceImage((WorkspaceImage)style, (WorkspaceImageDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof EllipseNodeDescription) {
            if (style instanceof Ellipse) {
                this.updateEllipse((Ellipse)style, (EllipseNodeDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        } else if (description instanceof LozengeNodeDescription) {
            if (style instanceof Lozenge) {
                this.updateLozenge((Lozenge)style, (LozengeNodeDescription)description, previousStyle);
            } else {
                brokenStyle = true;
            }
        }
        if (brokenStyle && style.eContainer() instanceof AbstractDNode) {
            EObject copy = EcoreUtil.copy((EObject)this.createNodeStyle(description));
            NodeStyle newStyle = (NodeStyle)copy;
            this.affectStyle((AbstractDNode)style.eContainer(), newStyle);
        }
        if (previousStyle.get() instanceof BorderedStyle) {
            this.updateBorderedStyleFeatures(description, style, previousStyle);
        } else {
            Option noPreviousBorderedStyle = Options.newNone();
            this.updateBorderedStyleFeatures(description, style, (Option<BorderedStyle>)noPreviousBorderedStyle);
        }
        if (previousStyle.some() && ((Style)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.NODE_STYLE__LABEL_POSITION.getName())) {
            if (previousStyle.get() instanceof NodeStyle) {
                style.setLabelPosition(((NodeStyle)previousStyle.get()).getLabelPosition());
            }
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.NODE_STYLE__LABEL_POSITION.getName());
        } else if (!style.getCustomFeatures().contains((Object)DiagramPackage.Literals.NODE_STYLE__LABEL_POSITION.getName())) {
            style.setLabelPosition(description.getLabelPosition());
        }
        this.updateHideLabelCapabilityFeature(description, style, previousStyle);
    }

    private void updateBorderedStyleFeatures(BorderedStyleDescription description, BorderedStyle style, Option<BorderedStyle> previousStyle) {
        if (previousStyle.some() && ((BorderedStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE.getName())) {
            style.setBorderSize(((BorderedStyle)previousStyle.get()).getBorderSize());
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE.getName());
        } else if (style.eContainer() instanceof AbstractDNode && style.getBorderSizeComputationExpression() != null && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE.getName())) {
            try {
                style.setBorderSize(this.interpreter.evaluateInteger(((AbstractDNode)style.eContainer()).getTarget(), description.getBorderSizeComputationExpression()));
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)StylePackage.eINSTANCE.getBorderedStyleDescription_BorderSizeComputationExpression(), (Throwable)e);
            }
        }
        if (previousStyle.some() && ((BorderedStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE_COMPUTATION_EXPRESSION.getName())) {
            style.setBorderSizeComputationExpression(((BorderedStyle)previousStyle.get()).getBorderSizeComputationExpression());
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE_COMPUTATION_EXPRESSION.getName());
        } else if (!style.getBorderSizeComputationExpression().equals(description.getBorderSizeComputationExpression()) && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE_COMPUTATION_EXPRESSION.getName())) {
            style.setBorderSizeComputationExpression(description.getBorderSizeComputationExpression());
        }
        if (previousStyle.some() && ((BorderedStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_LINE_STYLE.getName())) {
            style.setBorderLineStyle(((BorderedStyle)previousStyle.get()).getBorderLineStyle());
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_LINE_STYLE.getName());
        } else if (!style.getBorderLineStyle().equals((Object)description.getBorderLineStyle()) && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_LINE_STYLE.getName())) {
            style.setBorderLineStyle(description.getBorderLineStyle());
        }
    }

    private void affectStyle(AbstractDNode container, final NodeStyle newStyle) {
        DiagramSwitch<Object> sw = new DiagramSwitch<Object>(){

            @Override
            public Object caseDNode(DNode object) {
                object.setOwnedStyle(newStyle);
                return super.caseDNode(object);
            }

            @Override
            public Object caseDNodeListElement(DNodeListElement object) {
                object.setOwnedStyle(newStyle);
                return super.caseDNodeListElement(object);
            }
        };
        sw.doSwitch((EObject)container);
    }

    private FlatContainerStyle createFlatContainerStyle(FlatContainerStyleDescription description) {
        FlatContainerStyle style = DiagramFactory.eINSTANCE.createFlatContainerStyle();
        Option noPreviousStyle = Options.newNone();
        this.updateFlatContainerStyle(style, description, (Option<ContainerStyle>)noPreviousStyle);
        return style;
    }

    private void updateFlatContainerStyle(FlatContainerStyle style, FlatContainerStyleDescription description, Option<ContainerStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        if (previousStyle.some() && ((ContainerStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.FLAT_CONTAINER_STYLE__BACKGROUND_STYLE.getName()) && previousStyle.get() instanceof FlatContainerStyle) {
            style.setBackgroundStyle(((FlatContainerStyle)previousStyle.get()).getBackgroundStyle());
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.FLAT_CONTAINER_STYLE__BACKGROUND_STYLE.getName());
        } else if (style.getBackgroundStyle().getValue() != description.getBackgroundStyle().getValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.FLAT_CONTAINER_STYLE__BACKGROUND_STYLE.getName())) {
            style.setBackgroundStyle(description.getBackgroundStyle());
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        if (style.eContainer() instanceof DDiagramElementContainer) {
            this.setComputedSize((DDiagramElementContainer)style.eContainer(), description);
        }
    }

    private ShapeContainerStyle createShapeContainerStyle(ShapeContainerStyleDescription description) {
        ShapeContainerStyle style = DiagramFactory.eINSTANCE.createShapeContainerStyle();
        Option noPreviousStyle = Options.newNone();
        this.updateShapeContainerStyle(style, description, (Option<ContainerStyle>)noPreviousStyle);
        return style;
    }

    private void updateShapeContainerStyle(ShapeContainerStyle style, ShapeContainerStyleDescription description, Option<ContainerStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        if (previousStyle.some() && ((ContainerStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.SHAPE_CONTAINER_STYLE__SHAPE.getName()) && previousStyle.get() instanceof ShapeContainerStyle) {
            style.setShape(((ShapeContainerStyle)previousStyle.get()).getShape());
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.SHAPE_CONTAINER_STYLE__SHAPE.getName());
        } else if (style.getShape().getValue() != description.getShape().getValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.SHAPE_CONTAINER_STYLE__SHAPE.getName())) {
            style.setShape(description.getShape());
        }
        if (style.eContainer() instanceof DDiagramElementContainer) {
            this.setComputedSize((DDiagramElementContainer)style.eContainer(), description);
        }
    }

    private void setComputedSize(DDiagramElementContainer container, SizeComputationContainerStyleDescription style) {
        if (style != null) {
            Integer computedWidth = this.computeExpressions(container.getTarget(), style, (EStructuralFeature)StylePackage.eINSTANCE.getSizeComputationContainerStyleDescription_WidthComputationExpression());
            Integer computedHeight = this.computeExpressions(container.getTarget(), style, (EStructuralFeature)StylePackage.eINSTANCE.getSizeComputationContainerStyleDescription_HeightComputationExpression());
            this.safeSetComputedSize(container, computedWidth, computedHeight);
        }
    }

    private void safeSetComputedSize(DDiagramElementContainer container, Integer computedWidth, Integer computedHeight) {
        if (this.featureCanBeSet(computedWidth, container, (EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagramElementContainer_Width()) && !computedWidth.equals(container.getWidth())) {
            container.setWidth(computedWidth);
        }
        if (this.featureCanBeSet(computedHeight, container, (EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagramElementContainer_Height()) && !computedHeight.equals(container.getHeight())) {
            container.setHeight(computedHeight);
        }
    }

    private boolean featureCanBeSet(Integer value, DDiagramElementContainer container, EStructuralFeature feature) {
        boolean returnValue = false;
        if (container.eIsSet(feature)) {
            returnValue = true;
        } else if (value > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    private Integer computeExpressions(EObject target, SizeComputationContainerStyleDescription description, EStructuralFeature feature) {
        Integer size = null;
        Object expression = description.eGet(feature);
        if (expression instanceof String && !StringUtil.isEmpty((String)((String)expression)) && !((String)expression).equals("-1")) {
            try {
                size = this.interpreter.evaluateInteger(target, (String)expression);
                if (size == null) {
                    size = AUTO_SIZE_CONTAINER;
                }
            }
            catch (EvaluationException evaluationException) {}
        } else {
            size = AUTO_SIZE_CONTAINER;
        }
        return size;
    }

    private WorkspaceImage createWorkspaceImage(WorkspaceImageDescription description) {
        WorkspaceImage image = DiagramFactory.eINSTANCE.createWorkspaceImage();
        Option noPreviousStyle = Options.newNone();
        this.updateWorkspaceImage(image, description, (Option<? extends Style>)noPreviousStyle);
        return image;
    }

    private void updateWorkspaceImage(WorkspaceImage image, WorkspaceImageDescription description, Option<? extends Style> previousStyle) {
        if (image.getDescription() != description) {
            image.setDescription(description);
        }
        if (!previousStyle.some() || previousStyle.some() && previousStyle.get() instanceof LabelStyle) {
            this.updateLabelStyleFeatures(description, image, previousStyle);
        }
        if (previousStyle.some() && ((Style)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName()) && previousStyle.get() instanceof WorkspaceImage) {
            image.setWorkspacePath(((WorkspaceImage)previousStyle.get()).getWorkspacePath());
            image.getCustomFeatures().add((Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName());
        } else if (image.getWorkspacePath() == null || !image.getWorkspacePath().equals(description.getWorkspacePath()) && !image.getCustomFeatures().contains((Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName())) {
            image.setWorkspacePath(description.getWorkspacePath());
        }
        if (image.eContainer() instanceof DNode && description.getSizeComputationExpression() != null) {
            DNode node = (DNode)image.eContainer();
            Integer size = this.computeStyleSize(node.getTarget(), description);
            if (size == -1) {
                node.setHeight(size);
                node.setWidth(size);
            } else {
                this.safeSetComputedSize(node, size);
            }
        }
    }

    private BundledImage createBundledImage(BundledImageDescription description) {
        BundledImage image = DiagramFactory.eINSTANCE.createBundledImage();
        Option noPreviousStyle = Options.newNone();
        this.updateBundledImage(image, description, (Option<NodeStyle>)noPreviousStyle);
        return image;
    }

    private void updateBundledImage(BundledImage image, BundledImageDescription description, Option<NodeStyle> previousStyle) {
        if (image.getDescription() != description) {
            image.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, image, previousStyle);
        if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.BUNDLED_IMAGE__SHAPE.getName()) && previousStyle.get() instanceof BundledImage) {
            image.setShape(((BundledImage)previousStyle.get()).getShape());
            image.getCustomFeatures().add((Object)DiagramPackage.Literals.BUNDLED_IMAGE__SHAPE.getName());
        } else {
            if (image.getShape().getValue() != description.getShape().getValue() && !image.getCustomFeatures().contains((Object)DiagramPackage.Literals.BUNDLED_IMAGE__SHAPE.getName())) {
                image.setShape(description.getShape());
            }
            if (image.getShape() != null && image.getShape().equals((Object)BundledImageShape.PROVIDED_SHAPE_LITERAL) && description.getProvidedShapeID() != null && !description.getProvidedShapeID().equals(image.getProvidedShapeID())) {
                image.setProvidedShapeID(description.getProvidedShapeID());
            }
        }
    }

    private Note createNote(NoteDescription description) {
        Note style = DiagramFactory.eINSTANCE.createNote();
        Option noPreviousStyle = Options.newNone();
        this.updateNote(style, description, (Option<NodeStyle>)noPreviousStyle);
        return style;
    }

    private void updateNote(Note style, NoteDescription description, Option<NodeStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
    }

    private GaugeCompositeStyle createGaugeCompositeStyle(GaugeCompositeStyleDescription description) {
        GaugeCompositeStyle style = DiagramFactory.eINSTANCE.createGaugeCompositeStyle();
        Option noPreviousStyle = Options.newNone();
        this.updateGaugeCompositeStyle(style, description, (Option<NodeStyle>)noPreviousStyle);
        return style;
    }

    private void updateGaugeCompositeStyle(GaugeCompositeStyle style, GaugeCompositeStyleDescription description, Option<NodeStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        BasicEList newGaugeSections = new BasicEList();
        for (GaugeSectionDescription section : description.getSections()) {
            GaugeSection styleSection = DiagramFactory.eINSTANCE.createGaugeSection();
            styleSection.setLabel(section.getLabel());
            EObject context = null;
            if (style.eContainer() instanceof DSemanticDecorator) {
                context = ((DSemanticDecorator)style.eContainer()).getTarget();
            }
            if (context != null && context.eResource() != null) {
                Integer min = this.getIntFromExpression(context, section, (EStructuralFeature)StylePackage.eINSTANCE.getGaugeSectionDescription_MinValueExpression());
                Integer max = this.getIntFromExpression(context, section, (EStructuralFeature)StylePackage.eINSTANCE.getGaugeSectionDescription_MaxValueExpression());
                Integer value = this.getIntFromExpression(context, section, (EStructuralFeature)StylePackage.eINSTANCE.getGaugeSectionDescription_ValueExpression());
                styleSection.setMin(min);
                styleSection.setMax(max);
                if (value == null) {
                    styleSection.setValue(min);
                } else {
                    styleSection.setValue(value);
                }
                styleSection.setBackgroundColor(this.colorUpdater.getRGBValuesFromColorDescription(context, section.getBackgroundColor()));
                styleSection.setForegroundColor(this.colorUpdater.getRGBValuesFromColorDescription(context, section.getForegroundColor()));
            }
            newGaugeSections.add((Object)styleSection);
        }
        EcoreUtil.EqualityHelper equalityHelper = new EcoreUtil.EqualityHelper();
        if (!equalityHelper.equals(style.getSections(), (List)newGaugeSections) && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.GAUGE_COMPOSITE_STYLE__SECTIONS.getName())) {
            style.getSections().clear();
            style.getSections().addAll((Collection)newGaugeSections);
        }
        if (style.getAlignment().getValue() != description.getAlignment().getValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.GAUGE_COMPOSITE_STYLE__ALIGNMENT.getName())) {
            style.setAlignment(description.getAlignment());
        }
    }

    private Integer getIntFromExpression(EObject context, EObject descriptionObject, EStructuralFeature eFeature) {
        String computationExpression = (String)descriptionObject.eGet(eFeature);
        try {
            return this.interpreter.evaluateInteger(context, computationExpression);
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error(descriptionObject, eFeature, (Throwable)e);
            return 0;
        }
    }

    private Dot createDot(DotDescription description) {
        Dot style = DiagramFactory.eINSTANCE.createDot();
        Option noPreviousStyle = Options.newNone();
        this.updateDot(style, description, (Option<NodeStyle>)noPreviousStyle);
        return style;
    }

    private void updateDot(Dot style, DotDescription description, Option<NodeStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.DOT__STROKE_SIZE_COMPUTATION_EXPRESSION.getName()) && previousStyle.get() instanceof Dot) {
            style.setStrokeSizeComputationExpression(((Dot)previousStyle.get()).getStrokeSizeComputationExpression());
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.DOT__STROKE_SIZE_COMPUTATION_EXPRESSION.getName());
        } else if (!style.getStrokeSizeComputationExpression().equals(description.getStrokeSizeComputationExpression()) && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.DOT__STROKE_SIZE_COMPUTATION_EXPRESSION.getName())) {
            style.setStrokeSizeComputationExpression(description.getStrokeSizeComputationExpression());
        }
    }

    private Square createSquare(SquareDescription description) {
        Square style = DiagramFactory.eINSTANCE.createSquare();
        Option noPreviousStyle = Options.newNone();
        this.updateSquare(style, description, (Option<NodeStyle>)noPreviousStyle);
        return style;
    }

    private void updateSquare(Square style, SquareDescription description, Option<NodeStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        if (style.getHeight().intValue() != description.getHeight().intValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.SQUARE__HEIGHT.getName())) {
            style.setHeight(description.getHeight());
        }
        if (style.getWidth().intValue() != description.getWidth().intValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.SQUARE__WIDTH.getName())) {
            style.setWidth(description.getWidth());
        }
        if (style.eContainer() instanceof DNode) {
            DNode node = (DNode)style.eContainer();
            if (style.getWidth() != 0 && style.getHeight() != 0) {
                if (node.getWidth() == null || node.getWidth().intValue() != style.getWidth().intValue()) {
                    node.setWidth(style.getWidth());
                }
                if (node.getHeight() == null || node.getHeight().intValue() != style.getHeight().intValue()) {
                    node.setHeight(style.getHeight());
                }
            } else {
                this.setComputedSize(node, description);
            }
            if (style.getBorderSizeComputationExpression() != null && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.BORDERED_STYLE__BORDER_SIZE.getName())) {
                try {
                    style.setBorderSize(this.interpreter.evaluateInteger(node.getTarget(), description.getBorderSizeComputationExpression()));
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)StylePackage.eINSTANCE.getBorderedStyleDescription_BorderSizeComputationExpression(), (Throwable)e);
                }
            }
        }
    }

    private CustomStyle createCustomStyle(CustomStyleDescription description) {
        CustomStyle style = DiagramFactory.eINSTANCE.createCustomStyle();
        Option noPreviousStyle = Options.newNone();
        this.updateCustomStyle(style, description, (Option<NodeStyle>)noPreviousStyle);
        return style;
    }

    private void updateCustomStyle(CustomStyle style, CustomStyleDescription description, Option<NodeStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.CUSTOM_STYLE__ID.getName()) && previousStyle.get() instanceof CustomStyle) {
            style.setId(((CustomStyle)previousStyle.get()).getId());
            style.getCustomFeatures().add((Object)DiagramPackage.Literals.CUSTOM_STYLE__ID.getName());
        } else if (style.getId() == null || !style.getId().equals(description.getId()) && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.CUSTOM_STYLE__ID.getName())) {
            style.setId(description.getId());
        }
    }

    private Lozenge createLozenge(LozengeNodeDescription description) {
        Lozenge style = DiagramFactory.eINSTANCE.createLozenge();
        Option noPreviousStyle = Options.newNone();
        this.updateLozenge(style, description, (Option<NodeStyle>)noPreviousStyle);
        return style;
    }

    private void updateLozenge(Lozenge style, LozengeNodeDescription description, Option<NodeStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        if (style.eContainer() instanceof DNode) {
            DNode node = (DNode)style.eContainer();
            Integer width = 0;
            Integer height = 0;
            if (description.getWidthComputationExpression() != null && description.getHeightComputationExpression() != null) {
                try {
                    width = this.interpreter.evaluateInteger(node.getTarget(), description.getWidthComputationExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)StylePackage.eINSTANCE.getLozengeNodeDescription_WidthComputationExpression(), (Throwable)e);
                }
                try {
                    height = this.interpreter.evaluateInteger(node.getTarget(), description.getHeightComputationExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)StylePackage.eINSTANCE.getLozengeNodeDescription_HeightComputationExpression(), (Throwable)e);
                }
                if (height != null && width != null && width != 0 && height != 0) {
                    if (node.getWidth() == null || node.getWidth().intValue() != width.intValue()) {
                        node.setWidth(width);
                    }
                    if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.LOZENGE__WIDTH.getName()) && previousStyle.get() instanceof Lozenge) {
                        style.setWidth(((Lozenge)previousStyle.get()).getWidth());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.LOZENGE__WIDTH.getName());
                    } else if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.ELLIPSE__HORIZONTAL_DIAMETER.getName()) && previousStyle.get() instanceof Ellipse) {
                        style.setWidth(((Ellipse)previousStyle.get()).getHorizontalDiameter());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.LOZENGE__WIDTH.getName());
                    } else if (style.getWidth().intValue() != width.intValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.LOZENGE__WIDTH.getName())) {
                        style.setWidth(width);
                    }
                    if (node.getHeight() == null || node.getHeight().intValue() != height.intValue()) {
                        node.setHeight(height);
                    }
                    if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.LOZENGE__HEIGHT.getName()) && previousStyle.get() instanceof Lozenge) {
                        style.setHeight(((Lozenge)previousStyle.get()).getHeight());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.LOZENGE__HEIGHT.getName());
                    } else if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.ELLIPSE__VERTICAL_DIAMETER.getName()) && previousStyle.get() instanceof Ellipse) {
                        style.setHeight(((Ellipse)previousStyle.get()).getVerticalDiameter());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.LOZENGE__HEIGHT.getName());
                    } else if (style.getHeight().intValue() != height.intValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.LOZENGE__HEIGHT.getName())) {
                        style.setHeight(height);
                    }
                } else {
                    this.setComputedSize(node, description);
                }
            } else {
                this.setComputedSize(node, description);
            }
        }
    }

    private NodeStyle createEllipse(EllipseNodeDescription description) {
        Ellipse style = DiagramFactory.eINSTANCE.createEllipse();
        Option noPreviousStyle = Options.newNone();
        this.updateEllipse(style, description, (Option<NodeStyle>)noPreviousStyle);
        return style;
    }

    private void updateEllipse(Ellipse style, EllipseNodeDescription description, Option<NodeStyle> previousStyle) {
        if (style.getDescription() != description) {
            style.setDescription(description);
        }
        this.updateLabelStyleFeatures(description, style, previousStyle);
        if (style.eContainer() instanceof DNode) {
            DNode node = (DNode)style.eContainer();
            Integer width = 0;
            Integer height = 0;
            if (description.getHorizontalDiameterComputationExpression() != null && description.getVerticalDiameterComputationExpression() != null) {
                try {
                    width = this.interpreter.evaluateInteger(node.getTarget(), description.getHorizontalDiameterComputationExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)StylePackage.eINSTANCE.getEllipseNodeDescription_HorizontalDiameterComputationExpression(), (Throwable)e);
                }
                try {
                    height = this.interpreter.evaluateInteger(node.getTarget(), description.getVerticalDiameterComputationExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)StylePackage.eINSTANCE.getEllipseNodeDescription_VerticalDiameterComputationExpression(), (Throwable)e);
                }
                if (height != null && width != null && width != 0 && height != 0) {
                    if (node.getWidth() == null || node.getWidth().intValue() != width.intValue()) {
                        node.setWidth(width);
                    }
                    if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.LOZENGE__WIDTH.getName()) && previousStyle.get() instanceof Lozenge) {
                        style.setHorizontalDiameter(((Lozenge)previousStyle.get()).getWidth());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.ELLIPSE__HORIZONTAL_DIAMETER.getName());
                    } else if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.ELLIPSE__HORIZONTAL_DIAMETER.getName()) && previousStyle.get() instanceof Ellipse) {
                        style.setHorizontalDiameter(((Ellipse)previousStyle.get()).getHorizontalDiameter());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.ELLIPSE__HORIZONTAL_DIAMETER.getName());
                    } else if (style.getHorizontalDiameter().intValue() != width.intValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.ELLIPSE__HORIZONTAL_DIAMETER.getName())) {
                        style.setHorizontalDiameter(width);
                    }
                    if (node.getHeight() == null || node.getHeight().intValue() != height.intValue()) {
                        node.setHeight(height);
                    }
                    if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.LOZENGE__HEIGHT.getName()) && previousStyle.get() instanceof Lozenge) {
                        style.setVerticalDiameter(((Lozenge)previousStyle.get()).getHeight());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.ELLIPSE__VERTICAL_DIAMETER.getName());
                    } else if (previousStyle.some() && ((NodeStyle)previousStyle.get()).getCustomFeatures().contains((Object)DiagramPackage.Literals.ELLIPSE__VERTICAL_DIAMETER.getName()) && previousStyle.get() instanceof Ellipse) {
                        style.setVerticalDiameter(((Ellipse)previousStyle.get()).getVerticalDiameter());
                        style.getCustomFeatures().add((Object)DiagramPackage.Literals.ELLIPSE__VERTICAL_DIAMETER.getName());
                    } else if (style.getVerticalDiameter().intValue() != height.intValue() && !style.getCustomFeatures().contains((Object)DiagramPackage.Literals.ELLIPSE__VERTICAL_DIAMETER.getName())) {
                        style.setVerticalDiameter(height);
                    }
                } else {
                    this.setComputedSize(node, description);
                }
            } else {
                this.setComputedSize(node, description);
            }
        }
    }

    protected void refreshColors(Style style, Option<? extends Style> previousStyle) {
        EObject context = style.eContainer();
        if (style.getDescription() != null) {
            if (context != null) {
                if (context instanceof DSemanticDecorator) {
                    context = ((DSemanticDecorator)context).getTarget();
                }
                this.colorUpdater.updateColors(context, (Customizable)style, (EObject)style.getDescription(), previousStyle);
                this.refreshEdgeStyleWithContext(style, context, previousStyle);
            } else {
                this.colorUpdater.updateColors(style, style.getDescription(), previousStyle);
                this.refreshEdgeStyle(style, previousStyle);
            }
        }
    }

    private void refreshEdgeStyle(Style style, Option<? extends Style> previousStyle) {
        if (style instanceof EdgeStyle && (!previousStyle.some() || previousStyle.get() instanceof EdgeStyle)) {
            EndLabelStyle endLabelStyle;
            BeginLabelStyle beginLabelStyle;
            CenterLabelStyle centerLabelStyle = ((EdgeStyle)style).getCenterLabelStyle();
            if (centerLabelStyle != null) {
                Option previousCenterLabelStyle = Options.newNone();
                if (previousStyle.some()) {
                    previousCenterLabelStyle = Options.newSome((Object)((EdgeStyle)previousStyle.get()).getCenterLabelStyle());
                }
                this.colorUpdater.updateColors(centerLabelStyle, centerLabelStyle.getDescription(), (Option<? extends Customizable>)previousCenterLabelStyle);
            }
            if ((beginLabelStyle = ((EdgeStyle)style).getBeginLabelStyle()) != null) {
                Option previousBeginLabelStyle = Options.newNone();
                if (previousStyle.some()) {
                    previousBeginLabelStyle = Options.newSome((Object)((EdgeStyle)previousStyle.get()).getBeginLabelStyle());
                }
                this.colorUpdater.updateColors(beginLabelStyle, beginLabelStyle.getDescription(), (Option<? extends Customizable>)previousBeginLabelStyle);
            }
            if ((endLabelStyle = ((EdgeStyle)style).getEndLabelStyle()) != null) {
                Option previousEndLabelStyle = Options.newNone();
                if (previousStyle.some()) {
                    previousEndLabelStyle = Options.newSome((Object)((EdgeStyle)previousStyle.get()).getEndLabelStyle());
                }
                this.colorUpdater.updateColors(endLabelStyle, endLabelStyle.getDescription(), (Option<? extends Customizable>)previousEndLabelStyle);
            }
        }
    }

    private void refreshEdgeStyleWithContext(Style style, EObject context, Option<? extends Style> previousStyle) {
        if (style instanceof EdgeStyle) {
            EndLabelStyle endLabelStyle;
            BeginLabelStyle beginLabelStyle;
            CenterLabelStyle centerLabelStyle = ((EdgeStyle)style).getCenterLabelStyle();
            if (centerLabelStyle != null) {
                Option previousCenterLabelStyle = Options.newNone();
                if (previousStyle.some()) {
                    previousCenterLabelStyle = Options.newSome((Object)((EdgeStyle)previousStyle.get()).getCenterLabelStyle());
                }
                this.colorUpdater.updateColors(context, (Customizable)centerLabelStyle, (EObject)centerLabelStyle.getDescription(), (Option<? extends Customizable>)previousCenterLabelStyle);
            }
            if ((beginLabelStyle = ((EdgeStyle)style).getBeginLabelStyle()) != null) {
                Option previousBeginLabelStyle = Options.newNone();
                if (previousStyle.some()) {
                    previousBeginLabelStyle = Options.newSome((Object)((EdgeStyle)previousStyle.get()).getBeginLabelStyle());
                }
                this.colorUpdater.updateColors(context, (Customizable)beginLabelStyle, (EObject)beginLabelStyle.getDescription(), (Option<? extends Customizable>)previousBeginLabelStyle);
            }
            if ((endLabelStyle = ((EdgeStyle)style).getEndLabelStyle()) != null) {
                Option previousEndLabelStyle = Options.newNone();
                if (previousStyle.some()) {
                    previousEndLabelStyle = Options.newSome((Object)((EdgeStyle)previousStyle.get()).getEndLabelStyle());
                }
                this.colorUpdater.updateColors(context, (Customizable)endLabelStyle, (EObject)endLabelStyle.getDescription(), (Option<? extends Customizable>)previousEndLabelStyle);
            }
        }
    }

    public void setAndRefreshStyle(DDiagramElement diagramElement, Style currentStyle, Style bestStyle) {
        if (currentStyle == null) {
            new SetStyleSwitch(bestStyle).doSwitch((EObject)diagramElement);
            new RefreshStyleSwitch().doSwitch((EObject)diagramElement);
        } else if (bestStyle == currentStyle) {
            new RefreshStyleSwitch().doSwitch((EObject)diagramElement);
        } else if (bestStyle != null && (currentStyle.getDescription() == null || this.isDifferentDescription(bestStyle, currentStyle))) {
            new SetStyleSwitch(bestStyle).doSwitch((EObject)diagramElement);
            new RefreshStyleSwitch(Options.newSome((Object)currentStyle)).doSwitch((EObject)diagramElement);
        }
    }

    private boolean isDifferentDescription(Style bestStyle, Style currentStyle) {
        return !EqualityHelper.areEquals((EObject)bestStyle.getDescription(), (EObject)currentStyle.getDescription()) || !bestStyle.getClass().equals(currentStyle.getClass()) && currentStyle.getCustomFeatures().isEmpty();
    }

    public void setComputedSize(DNode node, NodeStyleDescription style) {
        if (style != null && !StringUtil.isEmpty((String)style.getSizeComputationExpression())) {
            Integer computedSize = this.computeStyleSize(node.getTarget(), style);
            this.safeSetComputedSize(node, computedSize);
        }
    }

    private void safeSetComputedSize(DNode node, Integer computedSize) {
        if (computedSize >= 0) {
            if (!computedSize.equals(node.getWidth())) {
                node.setWidth(computedSize);
            }
            if (!computedSize.equals(node.getHeight())) {
                node.setHeight(computedSize);
            }
        }
    }

    private Integer computeStyleSize(EObject target, NodeStyleDescription nodeStyle) {
        Integer computedSize = null;
        try {
            computedSize = this.interpreter.evaluateInteger(target, nodeStyle.getSizeComputationExpression());
        }
        catch (EvaluationException e) {
            RuntimeLoggerManager.INSTANCE.error((EObject)nodeStyle, (EStructuralFeature)StylePackage.eINSTANCE.getNodeStyleDescription_SizeComputationExpression(), (Throwable)e);
        }
        if (computedSize == null) {
            try {
                computedSize = Integer.parseInt(StylePackage.eINSTANCE.getNodeStyleDescription_SizeComputationExpression().getDefaultValueLiteral());
            }
            catch (NumberFormatException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)nodeStyle, (EStructuralFeature)StylePackage.eINSTANCE.getNodeStyleDescription_SizeComputationExpression(), (Throwable)e);
            }
        }
        if (computedSize == null) {
            computedSize = DEFAULT_SIZE;
        }
        return computedSize;
    }

    private final class RefreshStyleSwitch
    extends DiagramSwitch<Object> {
        Option<? extends Style> previousStyle = Options.newNone();

        private RefreshStyleSwitch() {
        }

        private RefreshStyleSwitch(Option<? extends Style> previousStyle) {
            this.previousStyle = previousStyle;
        }

        @Override
        public Object caseDEdge(DEdge object) {
            StyleHelper.this.refreshStyle(object.getOwnedStyle(), this.previousStyle);
            return null;
        }

        @Override
        public Object caseDNode(DNode object) {
            StyleHelper.this.refreshStyle(object.getOwnedStyle(), this.previousStyle);
            return null;
        }

        @Override
        public Object caseDNodeListElement(DNodeListElement object) {
            StyleHelper.this.refreshStyle(object.getOwnedStyle(), this.previousStyle);
            return null;
        }

        @Override
        public Object caseDNodeContainer(DNodeContainer object) {
            StyleHelper.this.refreshStyle(object.getOwnedStyle(), this.previousStyle);
            return null;
        }

        @Override
        public Object caseDNodeList(DNodeList object) {
            StyleHelper.this.refreshStyle(object.getOwnedStyle(), this.previousStyle);
            return null;
        }
    }

    private final class SetStyleSwitch
    extends DiagramSwitch<Object> {
        private final Style style;

        private SetStyleSwitch(Style style) {
            this.style = style;
        }

        @Override
        public Object caseDEdge(DEdge object) {
            object.setOwnedStyle((EdgeStyle)this.style);
            return null;
        }

        @Override
        public Object caseDNode(DNode object) {
            object.setOwnedStyle((NodeStyle)this.style);
            return null;
        }

        @Override
        public Object caseDNodeListElement(DNodeListElement object) {
            object.setOwnedStyle((NodeStyle)this.style);
            return null;
        }

        @Override
        public Object caseDNodeContainer(DNodeContainer object) {
            object.setOwnedStyle((ContainerStyle)this.style);
            return null;
        }

        @Override
        public Object caseDNodeList(DNodeList object) {
            object.setOwnedStyle((ContainerStyle)this.style);
            return null;
        }
    }
}

