/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sirius.common.ui.tools.api.dialog.FeatureEditorDialog;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.ui.business.internal.dialect.HierarchyLabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractEditorDialogPropertySection
extends AbstractViewpointPropertySection {
    protected Text text;
    protected Button button;
    protected CLabel nameLabel;
    protected Composite composite;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        if (aTabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)aTabbedPropertySheetPage);
        } else {
            super.createControls(parent, aTabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.text = this.getWidgetFactory().createText(this.composite, "");
        this.text.setEditable(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 232);
        data.right = new FormAttachment(95, 0);
        data.top = new FormAttachment(0, 4);
        this.text.setLayoutData((Object)data);
        this.button = this.getWidgetFactory().createButton(this.composite, "...", 8);
        data = new FormData();
        data.left = new FormAttachment(95, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.text, 0, 0x1000000);
        this.button.setLayoutData((Object)data);
        this.nameLabel = this.getWidgetFactory().createCLabel(this.composite, this.getLabelText());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.text, -25);
        data.top = new FormAttachment((Control)this.text, 0, 0x1000000);
        this.nameLabel.setLayoutData((Object)data);
        this.button.addSelectionListener(this.createButtonListener());
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.sirius." + this.eObject.eClass().getName());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.nameLabel.setText(this.getLabelText());
    }

    protected SelectionListener createButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)AbstractEditorDialogPropertySection.this.eObject, AbstractEditorDialogPropertySection.this.getIItemPropertyDescriptor());
                List currentValues = (List)AbstractEditorDialogPropertySection.this.eObject.eGet(AbstractEditorDialogPropertySection.this.getFeature());
                List<?> choiceOfValues = AbstractEditorDialogPropertySection.this.getChoiceOfValues(currentValues);
                FeatureEditorDialog dialog = new FeatureEditorDialog(AbstractEditorDialogPropertySection.this.composite.getShell(), AbstractEditorDialogPropertySection.this.getLabelProvider(propertyDescriptor), (Object)AbstractEditorDialogPropertySection.this.eObject, AbstractEditorDialogPropertySection.this.getFeature().getEType(), currentValues, propertyDescriptor.getDisplayName(), choiceOfValues, false, AbstractEditorDialogPropertySection.this.getIItemPropertyDescriptor().isSortChoices((Object)AbstractEditorDialogPropertySection.this.eObject), choiceOfValues != null);
                dialog.open();
                EList result = dialog.getResult();
                if (result != null) {
                    AbstractEditorDialogPropertySection.this.handleFeatureModified((List)result);
                }
            }
        };
    }

    protected ILabelProvider getLabelProvider(PropertyDescriptor propertyDescriptor) {
        ILabelProvider labelProvider = propertyDescriptor.getLabelProvider();
        if (this.getSelection() instanceof TreeSelection) {
            labelProvider = new HierarchyLabelProvider(labelProvider);
        }
        return labelProvider;
    }

    protected void handleFeatureModified(List result) {
        boolean equals = this.isEqual(result);
        if (!equals) {
            EditingDomain editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
            List value = result;
            if (this.eObjectList.size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.eObject, (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.eObjectList) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        if (this.text != null) {
            this.text.setText(this.getFeatureAsText());
        }
    }

    protected IItemPropertyDescriptor getIItemPropertyDescriptor() {
        IItemPropertyDescriptor itemPropertyDescriptor = null;
        ItemProviderAdapter providerAdapter = null;
        for (Object adapter : this.eObject.eAdapters()) {
            if (!(adapter instanceof ItemProviderAdapter)) continue;
            providerAdapter = (ItemProviderAdapter)adapter;
        }
        if (providerAdapter != null) {
            List propertyDescriptors = providerAdapter.getPropertyDescriptors((Object)this.eObject);
            for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
                if ((EStructuralFeature)propertyDescriptor.getFeature((Object)this.eObject) != this.getFeature()) continue;
                itemPropertyDescriptor = propertyDescriptor;
            }
        }
        return itemPropertyDescriptor;
    }

    protected List<?> getChoiceOfValues() {
        return this.getChoiceOfValues(Collections.emptyList());
    }

    protected List<?> getChoiceOfValues(List<?> currentValues) {
        List list = Collections.emptyList();
        Collection choiceOfValues = this.getIItemPropertyDescriptor().getChoiceOfValues((Object)this.eObject);
        choiceOfValues.removeAll(currentValues);
        if (choiceOfValues != null) {
            list = new ArrayList(choiceOfValues);
        }
        return list;
    }

    protected abstract boolean isEqual(List<?> var1);

    @Override
    protected abstract EStructuralFeature getFeature();

    protected String getDefaultFeatureAsText() {
        String value = new String();
        if (this.eObject.eGet(this.getFeature()) != null) {
            value = this.eObject.eGet(this.getFeature()).toString();
        }
        return value;
    }

    protected String getFeatureAsText() {
        EStructuralFeature eFeature = this.getFeature();
        IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(eFeature);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getLabelProvider((Object)this.eObject).getText(this.eObject.eGet(eFeature));
        }
        return this.getDefaultFeatureAsText();
    }

    protected abstract String getDefaultLabelText();

    protected String getLabelText() {
        EStructuralFeature eFeature;
        IItemPropertyDescriptor propertyDescriptor;
        if (this.eObject != null && (propertyDescriptor = this.getPropertyDescriptor(eFeature = this.getFeature())) != null) {
            return propertyDescriptor.getDisplayName((Object)this.eObject);
        }
        return this.getDefaultLabelText();
    }

    @Override
    protected void makeReadonly() {
        this.button.setEnabled(false);
        this.text.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.button.setEnabled(true);
        this.text.setEnabled(true);
    }
}

