/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.representationdescription;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.properties.ViewpointPropertySheetPage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractViewpointPropertySection;
import org.eclipse.sirius.editor.properties.sections.description.representationdescription.AddFromFilesystemButtonListener;
import org.eclipse.sirius.editor.properties.sections.description.representationdescription.AddFromRegistryButtonListener;
import org.eclipse.sirius.editor.properties.sections.description.representationdescription.AddFromWorkspaceButtonListener;
import org.eclipse.sirius.editor.properties.sections.description.representationdescription.RemoveMetamodelsSelectionButtonListener;
import org.eclipse.sirius.editor.properties.sections.description.representationdescription.RepresentationDescriptionMetamodelsUpdater;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RepresentationDescriptionMetamodelPropertySectionSpec
extends AbstractViewpointPropertySection {
    private CLabel help;
    protected Composite composite;
    protected Label listHeader;
    protected Table metamodelsTable;
    protected Button addFromRegistryButton;
    protected Button addFromWorkspaceButton;
    protected Button addFromFilesystemButton;
    protected Button removeMetamodelsSelectionButton;
    protected RepresentationDescriptionMetamodelsUpdater representationDescriptionMetamodelsUpdater;

    @Override
    protected void makeReadonly() {
        this.metamodelsTable.setEnabled(false);
        this.addFromRegistryButton.setEnabled(false);
        this.addFromWorkspaceButton.setEnabled(false);
        this.addFromFilesystemButton.setEnabled(false);
        this.removeMetamodelsSelectionButton.setEnabled(false);
    }

    @Override
    protected void makeWrittable() {
        this.metamodelsTable.setEnabled(true);
        this.addFromRegistryButton.setEnabled(true);
        this.addFromWorkspaceButton.setEnabled(true);
        this.addFromFilesystemButton.setEnabled(true);
    }

    @Override
    protected EStructuralFeature getFeature() {
        return DescriptionPackage.eINSTANCE.getRepresentationDescription_Metamodel();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        if (aTabbedPropertySheetPage instanceof ViewpointPropertySheetPage) {
            super.createControls(parent, (ViewpointPropertySheetPage)aTabbedPropertySheetPage);
        } else {
            super.createControls(parent, aTabbedPropertySheetPage);
        }
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.help = this.getWidgetFactory().createCLabel(this.composite, "");
        this.help.setImage(this.getHelpIcon());
        this.help.setToolTipText("Select the Metamodels (EPackage) which must be used in the current representation description");
        this.listHeader = this.getWidgetFactory().createLabel(this.composite, "Selected Metamodels : ");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 25);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.listHeader.setLayoutData((Object)data);
        int style = 68354;
        this.metamodelsTable = this.getWidgetFactory().createTable(this.composite, style);
        this.metamodelsTable.setLinesVisible(true);
        this.metamodelsTable.setHeaderVisible(true);
        TableColumn ePackageNameColumn = new TableColumn(this.metamodelsTable, 0);
        ePackageNameColumn.setText("Name");
        TableColumn ePackageNSURIColumn = new TableColumn(this.metamodelsTable, 0);
        ePackageNSURIColumn.setText("nsURI");
        TableColumn ecoreResourceURIColumn = new TableColumn(this.metamodelsTable, 0);
        ecoreResourceURIColumn.setText("metamodel URI");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment((Control)this.listHeader, 0, 4);
        data.height = 120;
        data.width = 200;
        this.metamodelsTable.setLayoutData((Object)data);
        this.addButtons();
    }

    protected void addButtons() {
        RepresentationDescription representationDescription = (RepresentationDescription)this.eObject;
        this.representationDescriptionMetamodelsUpdater = new RepresentationDescriptionMetamodelsUpdater(representationDescription);
        this.addFromRegistryButton = this.getWidgetFactory().createButton(this.composite, "Add from registry", 8);
        this.addFromRegistryButton.addSelectionListener((SelectionListener)new AddFromRegistryButtonListener(this, this.representationDescriptionMetamodelsUpdater));
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.listHeader, 0, 131072);
        data.left = new FormAttachment((Control)this.metamodelsTable, 6, 131072);
        data.right = new FormAttachment(100);
        data.width = 60;
        this.addFromRegistryButton.setLayoutData((Object)data);
        this.addFromWorkspaceButton = this.getWidgetFactory().createButton(this.composite, "Add from workspace", 8);
        this.addFromWorkspaceButton.addSelectionListener((SelectionListener)new AddFromWorkspaceButtonListener(this, this.representationDescriptionMetamodelsUpdater));
        data = new FormData();
        data.top = new FormAttachment((Control)this.addFromRegistryButton, 6, 131072);
        data.left = new FormAttachment((Control)this.metamodelsTable, 6, 131072);
        data.right = new FormAttachment(100);
        data.width = 60;
        this.addFromWorkspaceButton.setLayoutData((Object)data);
        this.addFromFilesystemButton = this.getWidgetFactory().createButton(this.composite, "Add from filesystem", 8);
        this.addFromFilesystemButton.addSelectionListener((SelectionListener)new AddFromFilesystemButtonListener(this, this.representationDescriptionMetamodelsUpdater));
        data = new FormData();
        data.top = new FormAttachment((Control)this.addFromWorkspaceButton, 6, 131072);
        data.left = new FormAttachment((Control)this.metamodelsTable, 6, 131072);
        data.right = new FormAttachment(100);
        data.width = 60;
        this.addFromFilesystemButton.setLayoutData((Object)data);
        this.removeMetamodelsSelectionButton = this.getWidgetFactory().createButton(this.composite, "Remove", 8);
        this.removeMetamodelsSelectionButton.addSelectionListener((SelectionListener)new RemoveMetamodelsSelectionButtonListener(this, this.removeMetamodelsSelectionButton, this.metamodelsTable, this.representationDescriptionMetamodelsUpdater));
        this.removeMetamodelsSelectionButton.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)this.addFromFilesystemButton, 6, 131072);
        data.left = new FormAttachment((Control)this.metamodelsTable, 6, 131072);
        data.right = new FormAttachment(100);
        data.width = 60;
        this.removeMetamodelsSelectionButton.setLayoutData((Object)data);
    }

    public void refresh() {
        List<EPackage> ePackages;
        if (this.eObject instanceof RepresentationDescription) {
            this.representationDescriptionMetamodelsUpdater.setRepresentationDescription((RepresentationDescription)this.eObject);
        }
        if ((ePackages = this.getValue()) != null) {
            List<EPackage> previousEPackages = this.getEPackages(this.metamodelsTable.getItems());
            int previousSelectionIndex = this.metamodelsTable.getSelectionIndex();
            this.metamodelsTable.removeAll();
            ArrayList<TableItem> newItems = new ArrayList<TableItem>();
            for (EPackage ePackage : ePackages) {
                String ePackageURI;
                TableItem item = new TableItem(this.metamodelsTable, 0);
                item.setData((Object)ePackage);
                if (ePackage.eResource() != null) {
                    String ePackageName = ePackage.getName();
                    if (ePackageName == null) {
                        ePackageName = "null";
                    }
                    item.setText(0, ePackageName);
                    String ePackageNSURI = ePackage.getNsURI();
                    if (ePackageNSURI == null) {
                        ePackageNSURI = "null";
                    }
                    item.setText(1, ePackageNSURI);
                    ePackageURI = null;
                    URI completeURIToEPackage = this.representationDescriptionMetamodelsUpdater.getCompleteURIToEPackage(ePackage);
                    if (completeURIToEPackage != null) {
                        ePackageURI = URI.decode((String)completeURIToEPackage.toString());
                    } else {
                        URI genModelResourceURI = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap().get(ePackage.getNsURI());
                        if (genModelResourceURI != null) {
                            ePackageURI = genModelResourceURI.trimFileExtension().appendFileExtension("ecore").toString();
                        }
                    }
                    if (ePackageURI == null) {
                        ePackageURI = "unknow metamodel resource URI";
                    }
                    item.setText(2, ePackageURI);
                    if (previousEPackages.contains(ePackage)) continue;
                    newItems.add(item);
                    continue;
                }
                URI proxyURI = ((InternalEObject)ePackage).eProxyURI();
                String ePackageName = proxyURI.lastSegment().substring(0, proxyURI.lastSegment().indexOf(46));
                item.setText(0, ePackageName);
                item.setText(1, "null");
                ePackageURI = proxyURI.trimFragment().toString();
                item.setText(2, ePackageURI);
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
                Image img = fieldDecoration.getImage();
                item.setImage(img);
                SiriusEditorPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.editor", "Invalid ressource access for the metamodel " + ePackageURI));
            }
            if (!newItems.isEmpty()) {
                this.metamodelsTable.setSelection(newItems.toArray(new TableItem[0]));
                this.removeMetamodelsSelectionButton.setEnabled(true);
            } else {
                this.metamodelsTable.select(previousSelectionIndex - 1);
            }
        }
        if (this.metamodelsTable.getSelectionCount() == 0) {
            this.removeMetamodelsSelectionButton.setEnabled(false);
        }
        this.metamodelsTable.getColumn(0).pack();
        this.metamodelsTable.getColumn(1).pack();
        this.metamodelsTable.getColumn(2).pack();
    }

    public EditingDomain getEditingDomain() {
        EditingDomain editingDomain = null;
        if (this.getPart() instanceof IEditingDomainProvider) {
            editingDomain = ((IEditingDomainProvider)this.getPart()).getEditingDomain();
        }
        return editingDomain;
    }

    public List<EPackage> getEPackages(TableItem[] selection) {
        ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() instanceof EPackage) {
                ePackages.add((EPackage)item.getData());
            }
            ++n2;
        }
        return ePackages;
    }

    protected List<EPackage> getValue() {
        List values;
        List<Object> ePackages = new ArrayList<EPackage>();
        Object object = this.eObject.eGet(this.getFeature());
        if (object instanceof List && !(values = (List)object).isEmpty() && values.get(0) instanceof EPackage) {
            ePackages = values;
        }
        return ePackages;
    }

    public void dispose() {
        if (this.representationDescriptionMetamodelsUpdater != null) {
            this.representationDescriptionMetamodelsUpdater.dispose();
            this.representationDescriptionMetamodelsUpdater = null;
        }
        this.removeMetamodelsSelectionButton = null;
        this.addFromFilesystemButton = null;
        this.addFromWorkspaceButton = null;
        this.addFromRegistryButton = null;
        this.metamodelsTable = null;
        this.listHeader = null;
        this.composite = null;
        this.help = null;
        super.dispose();
    }
}

