/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.api.menu;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.internal.metamodel.helper.EClassHelper;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.editor.tools.internal.editor.EditorCustomizationManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractMenuBuilder {
    protected static final int CONDITIONAL_STYLE;
    protected static final int CUSTOMIZATION;
    protected static final int DIAGRAM_ELEMENT;
    protected static final int ELEMENT_CREATION;
    protected static final int ELEMENT_EDITION;
    protected static final int EXTENSION;
    protected static final int FILTER;
    protected static final int IMPORT;
    protected static final int LAYOUT;
    protected static final int MENU;
    protected static final int NAVIGATION;
    protected static final int OPERATION;
    protected static final int REORDER;
    protected static final int REPRESENTATION;
    protected static final int REPRESENTATION_CREATION;
    protected static final int SIMULATION;
    protected static final int STYLE;
    protected static final int TABLE_ELEMENT;
    protected static final int TEMPLATE;
    protected static final int TOOL;
    protected static final int TREE_ELEMENT;
    protected static final int VALIDATION;
    protected static final int VARIABLE;
    protected static final int OTHERS;
    protected static final int INITIALIZE;
    protected static final int REFACTOR;
    private static final String EDIT = "edit";
    private static final int DEFAULT_PRIORITY = 1000000000;
    protected Collection advancedChildActions;
    protected Collection descriptors;
    protected IMenuManager myMenuManager;
    private Map<String, Integer> priorityMap = Maps.newHashMap();

    static {
        SiriusEditorPlugin rl = SiriusEditorPlugin.INSTANCE;
        CONDITIONAL_STYLE = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ConditionalStylePriority");
        CUSTOMIZATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "CustomizationPriority");
        DIAGRAM_ELEMENT = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "DiagramElementPriority");
        ELEMENT_CREATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ElementCreationPriority");
        ELEMENT_EDITION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ElementEditionPriority");
        EXTENSION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ExtensionPriority");
        FILTER = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "FilterPriority");
        IMPORT = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ImportPriority");
        LAYOUT = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "LayoutPriority");
        MENU = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "MenuPriority");
        NAVIGATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "NavigationPriority");
        OPERATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "OperationPriority");
        REORDER = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ReorderPriority");
        REPRESENTATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "RepresentationPriority");
        REPRESENTATION_CREATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "RepresentationCreationPriority");
        SIMULATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "SimulationPriority");
        STYLE = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "StylePriority");
        TABLE_ELEMENT = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "TableElementPriority");
        TEMPLATE = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "TemplatePriority");
        TOOL = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ToolPriority");
        TREE_ELEMENT = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "TreeElementPriority");
        VALIDATION = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "ValidationPriority");
        VARIABLE = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "VariablePriority");
        OTHERS = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "OthersPriority");
        INITIALIZE = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "InitializePriority");
        REFACTOR = AbstractMenuBuilder.getPriority((ResourceLocator)rl, "RefactorPriority");
    }

    public AbstractMenuBuilder() {
        this.descriptors = new LinkedHashSet();
        this.getMenu();
    }

    private static int getPriority(ResourceLocator rl, String id) {
        try {
            return Integer.parseInt(rl.getString(id).trim());
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (MissingResourceException missingResourceException) {}
        return 100000;
    }

    public Collection getMyDescriptors() {
        return this.descriptors;
    }

    protected Option<IMenuManager> getMenu() {
        return Options.newSome((Object)this.myMenuManager);
    }

    private void createMenuManager() {
        this.myMenuManager = new MenuManager(this.getLabel());
        this.myMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
    }

    public abstract String getLabel();

    public abstract int getPriority();

    public void attach(IMenuManager parent) {
    }

    public void update(Collection newChildDescriptors, ISelection selection, IEditorPart editor) {
        this.depopulate();
        this.advancedChildActions = this.generateCreateChildActions(this.filter(newChildDescriptors), selection, editor);
    }

    private Collection filter(Collection newChildDescriptors) {
        for (Object object : newChildDescriptors) {
            if (object instanceof CommandParameter) {
                if (this.isDeprecated((CommandParameter)object) || !this.isMine((CommandParameter)object)) continue;
                this.descriptors.add(object);
                continue;
            }
            this.descriptors.add(object);
        }
        return this.descriptors;
    }

    protected abstract boolean isMine(CommandParameter var1);

    protected boolean isDeprecated(CommandParameter param) {
        return param.getEStructuralFeature() != null && this.isDeprecated((EModelElement)param.getEStructuralFeature()) || param.getValue() instanceof EObject && this.isDeprecated((EModelElement)((EObject)param.getValue()).eClass());
    }

    private boolean isDeprecated(EModelElement owner) {
        return this.isGlobalyDisabled(owner) || EditorCustomizationManager.getInstance().isHidden(owner);
    }

    private boolean isGlobalyDisabled(EModelElement owner) {
        return owner == DescriptionPackage.eINSTANCE.getRepresentationTemplate_OwnedRepresentations();
    }

    protected void depopulate() {
        this.descriptors = new LinkedHashSet();
        if (this.myMenuManager != null) {
            this.depopulateManager((IContributionManager)this.myMenuManager, this.advancedChildActions);
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection actions) {
        if (actions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem item;
                IContributionItem contributionItem = item = iContributionItemArray[n2];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    protected Collection generateCreateChildActions(Collection actionDescriptors, ISelection selection, IEditorPart editor) {
        ArrayList<CreateChildAction> actions = new ArrayList<CreateChildAction>();
        if (actionDescriptors != null) {
            for (Object actionDescriptor : actionDescriptors) {
                CreateChildAction cca = actionDescriptor instanceof CommandParameter ? new CustomCreateChildAction(editor, selection, (CommandParameter)actionDescriptor) : new CreateChildAction(editor, selection, actionDescriptor);
                actions.add(cca);
            }
        }
        return actions;
    }

    public void populateMenu() {
        if (this.getMenu().some()) {
            this.populateManager((IContributionManager)this.getMenu().get(), this.advancedChildActions, null);
        }
    }

    public void depopulateMenu() {
        if (this.getMenu().some()) {
            this.depopulateManager((IContributionManager)this.getMenu().get(), this.advancedChildActions);
        }
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            ArrayList sortedActions = Lists.newArrayList((Iterable)Iterables.filter((Iterable)actions, IAction.class));
            Comparator<IAction> comparator = new Comparator<IAction>(){

                @Override
                public int compare(IAction a1, IAction a2) {
                    int diff = AbstractMenuBuilder.this.getPriority(a1) - AbstractMenuBuilder.this.getPriority(a2);
                    if (diff == 0) {
                        diff = Collator.getInstance().compare(a1.getText(), a2.getText());
                    }
                    return diff;
                }
            };
            Collections.sort(sortedActions, comparator);
            for (IAction action : sortedActions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
        manager.update(true);
    }

    private int getPriority(IAction action) {
        if (action instanceof CustomCreateChildAction) {
            return this.getPriority(((CustomCreateChildAction)action).getCreatedElementType());
        }
        return 1000000000;
    }

    private int getPriority(String key) {
        if (key != null && !this.priorityMap.containsKey(key)) {
            int priority = 1000000000;
            try {
                priority = Integer.parseInt(SiriusEditorPlugin.INSTANCE.getString(key).trim());
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {}
            this.priorityMap.put(key, priority);
        }
        return (Integer)Objects.firstNonNull((Object)this.priorityMap.get(key), (Object)1000000000);
    }

    public void insertBeforeInContainer(IMenuManager parent) {
        this.createMenuManager();
        this.populateMenu();
        parent.insertBefore(EDIT, (IContributionItem)this.myMenuManager);
    }

    public void insertAfterInContainer(IMenuManager parent) {
        this.createMenuManager();
        this.populateMenu();
        parent.insertAfter(EDIT, (IContributionItem)this.myMenuManager);
    }

    private final class CustomCreateChildAction
    extends CreateChildAction {
        private final String key;

        private CustomCreateChildAction(IEditorPart editorPart, ISelection selection, CommandParameter descriptor) {
            super(editorPart, selection, (Object)descriptor);
            this.key = descriptor.getValue() instanceof EObject ? EClassHelper.getPath((EClass)((EObject)descriptor.getValue()).eClass()) : null;
        }

        public String getCreatedElementType() {
            return this.key;
        }

        public String toString() {
            return "CustomCreateChildAction[key = " + this.key + "]";
        }
    }
}

