/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.business.internal.dialect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.table.business.internal.metamodel.TableToolVariables;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionFactory;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableCreationDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableNavigationDescription;
import org.eclipse.sirius.table.metamodel.table.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.metamodel.table.provider.TableItemProviderAdapterFactory;
import org.eclipse.sirius.table.metamodel.table.provider.TableUIPlugin;
import org.eclipse.sirius.table.tools.api.export.TableExportHelper;
import org.eclipse.sirius.table.ui.tools.api.editor.DTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIServices;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.internal.dialect.HierarchyLabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class TableDialectUIServices
implements DialectUIServices {
    public IEditorPart openEditor(Session session, DRepresentation dRepresentation, IProgressMonitor monitor) {
        IEditorPart editorPart = null;
        try {
            monitor.beginTask(Messages.TableDialectUIServices_tableOpening, 10);
            if (dRepresentation instanceof DTable) {
                DTable dTable = (DTable)dRepresentation;
                DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.OPEN_TABLE_KEY);
                URI uri = EcoreUtil.getURI((EObject)dTable);
                String editorName = DialectUIManager.INSTANCE.getEditorName((DRepresentation)dTable);
                monitor.worked(2);
                SessionEditorInput editorInput = new SessionEditorInput(uri, editorName, session);
                String editorId = dTable.getDescription() instanceof EditionTableDescription ? "org.eclipse.sirius.table.ui.EditionTableEditorID" : (dTable.getDescription() instanceof CrossTableDescription ? "org.eclipse.sirius.table.ui.CrossTableEditorID" : null);
                if (editorId != null) {
                    monitor.subTask(MessageFormat.format(Messages.TableDialectUIServices_tableOpeningVar, dRepresentation.getName()));
                    RunnableWithResult.Impl<IEditorPart> runnable = new RunnableWithResult.Impl<IEditorPart>((IEditorInput)editorInput, editorId){
                        private final /* synthetic */ IEditorInput val$editorInput;
                        private final /* synthetic */ String val$editorId;
                        {
                            this.val$editorInput = iEditorInput;
                            this.val$editorId = string;
                        }

                        public void run() {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                this.setResult(page.openEditor(this.val$editorInput, this.val$editorId));
                            }
                            catch (PartInitException e) {
                                TableUIPlugin.getPlugin().log(new Status(4, "org.eclipse.sirius.table.ui", Messages.TableDialectUIServices_tableOpeningError, (Throwable)e));
                            }
                        }
                    };
                    EclipseUIUtil.displaySyncExec((Runnable)runnable);
                    monitor.worked(8);
                    if (runnable.getResult() instanceof AbstractDTableEditor) {
                        editorPart = (IEditorPart)runnable.getResult();
                    }
                }
                DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.OPEN_TABLE_KEY);
            }
        }
        finally {
            monitor.done();
        }
        return editorPart;
    }

    public Collection<CommandParameter> provideNewChildDescriptors() {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        newChilds.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.VIEWPOINT__OWNED_REPRESENTATIONS, (Object)DescriptionFactory.eINSTANCE.createEditionTableDescription()));
        newChilds.add(new CommandParameter(null, (Object)DescriptionPackage.Literals.VIEWPOINT__OWNED_REPRESENTATIONS, (Object)DescriptionFactory.eINSTANCE.createCrossTableDescription()));
        return newChilds;
    }

    public Collection<CommandParameter> provideRepresentationCreationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        TableCreationDescription tableCreationDescription = DescriptionFactory.eINSTANCE.createTableCreationDescription();
        new TableToolVariables().doSwitch((EObject)tableCreationDescription);
        newChilds.add(new CommandParameter(null, feature, (Object)tableCreationDescription));
        return newChilds;
    }

    public Collection<CommandParameter> provideRepresentationNavigationToolDescriptors(Object feature) {
        ArrayList<CommandParameter> newChilds = new ArrayList<CommandParameter>();
        TableNavigationDescription tableNavigationDescription = DescriptionFactory.eINSTANCE.createTableNavigationDescription();
        new TableToolVariables().doSwitch((EObject)tableNavigationDescription);
        newChilds.add(new CommandParameter(null, feature, (Object)tableNavigationDescription));
        return newChilds;
    }

    public AdapterFactory createAdapterFactory() {
        ComposedAdapterFactory factory = new ComposedAdapterFactory();
        factory.addAdapterFactory((AdapterFactory)new DescriptionItemProviderAdapterFactory());
        factory.addAdapterFactory((AdapterFactory)new TableItemProviderAdapterFactory());
        return factory;
    }

    public boolean canHandleEditor(IEditorPart editorPart) {
        return editorPart instanceof AbstractDTableEditor;
    }

    public boolean closeEditor(final IEditorPart editorPart, final boolean save) {
        if (editorPart instanceof AbstractDTableEditor) {
            Display display = editorPart.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorPart, save);
                }
            });
        }
        return true;
    }

    public boolean isRepresentationManagedByEditor(DRepresentation representation, IEditorPart editorPart) {
        AbstractDTableEditor tableEditor;
        boolean isRepresentationManagedByEditor = false;
        if (editorPart instanceof AbstractDTableEditor && (tableEditor = (AbstractDTableEditor)editorPart).getTableModel() != null && tableEditor.getTableModel().equals(representation)) {
            isRepresentationManagedByEditor = true;
        }
        return isRepresentationManagedByEditor;
    }

    public boolean isRepresentationDescriptionManagedByEditor(RepresentationDescription representationDescription, IEditorPart editor) {
        if (editor instanceof AbstractDTableEditor) {
            AbstractDTableEditor tableEditor = (AbstractDTableEditor)editor;
            return EcoreUtil.equals((EObject)tableEditor.getTableModel().getDescription(), (EObject)representationDescription);
        }
        return false;
    }

    public boolean canHandle(DRepresentation representation) {
        return representation instanceof DTable;
    }

    public boolean canHandle(RepresentationDescription representation) {
        return representation instanceof TableDescription;
    }

    public boolean canHandle(RepresentationExtensionDescription description) {
        return false;
    }

    public boolean canExport(ExportFormat format) {
        return format.getDocumentFormat().equals((Object)ExportFormat.ExportDocumentFormat.CSV);
    }

    public void export(DRepresentation representation, Session session, IPath path, ExportFormat exportFormat, IProgressMonitor monitor) {
        String content = null;
        if (exportFormat.getDocumentFormat().equals((Object)ExportFormat.ExportDocumentFormat.CSV)) {
            content = TableExportHelper.INSTANCE.exportToCsv((DTable)representation);
        }
        if (!StringUtil.isEmpty(content)) {
            TableExportHelper.INSTANCE.saveContent(content, path.toOSString());
        }
    }

    public String getEditorName(DRepresentation representation) {
        String editorName = representation.getName();
        if (StringUtil.isEmpty((String)editorName)) {
            editorName = Messages.TableDialectUIServices_newTableName;
        }
        return editorName;
    }

    public Collection<CommandParameter> provideTools(EObject context) {
        return Lists.newArrayList();
    }

    public Collection<CommandParameter> provideAdditionalMappings(EObject object) {
        return Lists.newArrayList();
    }

    public ILabelProvider getHierarchyLabelProvider(ILabelProvider labelProvider) {
        return new HierarchyLabelProvider(labelProvider);
    }

    public void setSelection(DialectEditor dialectEditor, List<DRepresentationElement> selection) {
        if (dialectEditor instanceof DTableEditor && dialectEditor instanceof IViewerProvider) {
            Viewer viewer = ((IViewerProvider)dialectEditor).getViewer();
            Iterable tableElements = Iterables.filter(selection, DTableElement.class);
            if (viewer != null) {
                viewer.setSelection((ISelection)new StructuredSelection((List)Lists.newArrayList((Iterable)tableElements)));
            }
        }
    }

    public void selectAndReveal(DialectEditor dialectEditor, List<DRepresentationElement> selection) {
        this.setSelection(dialectEditor, selection);
    }

    public Collection<DSemanticDecorator> getSelection(DialectEditor editor) {
        LinkedHashSet selection = Sets.newLinkedHashSet();
        if (editor instanceof DTableEditor) {
            ISelection sel;
            DTableEditor dEditor = (DTableEditor)editor;
            if (editor.getSite() != null && editor.getSite().getSelectionProvider() != null && (sel = dEditor.getSite().getSelectionProvider().getSelection()) instanceof IStructuredSelection) {
                Iterables.addAll((Collection)selection, (Iterable)Iterables.filter((Iterable)((IStructuredSelection)sel).toList(), DSemanticDecorator.class));
            }
        }
        return selection;
    }

    public String completeToolTipText(String toolTipText, EObject eObject, EStructuralFeature feature) {
        return toolTipText;
    }

    @Deprecated
    public String completeToolTipText(String toolTipText, EObject eObject) {
        return toolTipText;
    }
}

