/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.print;

import java.text.MessageFormat;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PageSetup;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PrintCallback;
import org.eclipse.sirius.table.ui.tools.internal.editor.print.PrintJobParameters;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PrintAsImageCallback
implements PrintCallback {
    private static final double HEADER_MARGIN_PERCENT = 0.05;
    private static final double FOOTER_MARGIN_PERCENT = 0.05;
    private PageSetup pageSetup;
    private Image imageToPrint;
    private PrintJobParameters printParameters;
    private double scaleFactor;
    private ImageData imageData;
    private ImageHeightBoundsForPage[] heightBounds;
    private Display display;
    private int maxPageHeight;
    private int maxPageWidth;
    private int headerMargin;
    private int footerMargin;

    public PrintAsImageCallback(PageSetup pageSetup, Control control) {
        this.pageSetup = pageSetup;
        this.display = control.getDisplay();
        this.imageToPrint = this.takeSnapshot(control);
    }

    private Image takeSnapshot(final Control control) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                this.synchronizationWithUIThread();
                control.redraw();
                control.update();
            }

            private void synchronizationWithUIThread() {
                while (PrintAsImageCallback.this.display.readAndDispatch()) {
                }
            }
        });
        RunnableWithResult.Impl<Image> runnable = new RunnableWithResult.Impl<Image>(){

            public void run() {
                Point size = control.getSize();
                Image snap = new Image((Device)PrintAsImageCallback.this.display, size.x, size.y);
                GC gc = new GC((Drawable)control);
                gc.copyArea(snap, 0, 0);
                gc.dispose();
                this.setResult(snap);
            }
        };
        this.display.syncExec((Runnable)runnable);
        return (Image)runnable.getResult();
    }

    @Override
    public void setParameters(PrintJobParameters parameters) {
        this.printParameters = parameters;
        this.imageData = this.imageToPrint.getImageData();
        this.computeMaxPageWidth();
        this.adaptScaleFactor();
        this.computeMaxPageHeightAndMargin();
        this.setHeightBounds();
    }

    private void adaptScaleFactor() {
        int test = (int)((double)this.imageData.width * this.printParameters.getScaleFactor());
        if (test > this.maxPageWidth) {
            this.scaleFactor = (double)this.maxPageWidth / (double)this.imageData.width;
        }
    }

    private void setHeightBounds() {
        int numberOfPages = this.numberOfPages();
        this.heightBounds = new ImageHeightBoundsForPage[numberOfPages];
        int i = 0;
        while (i < numberOfPages) {
            int height = this.computeHeightForPage(i);
            int src = i == 0 ? 0 : this.heightBounds[i - 1].getDest() + 1;
            this.heightBounds[i] = new ImageHeightBoundsForPage(src, src + height);
            ++i;
        }
    }

    @Override
    public int numberOfPages() {
        return this.imageData.height / this.maxPageHeight + 1;
    }

    private void computeMaxPageHeightAndMargin() {
        int max = PageSetup.size(PageSetup.inches(this.pageSetup.getDimension().getHeight()), this.printParameters.getPrinter().getDPI().y);
        this.headerMargin = this.computeMargin(max, 0.05);
        this.footerMargin = this.computeMargin(max, 0.05);
        this.maxPageHeight = max - this.headerMargin - this.footerMargin;
    }

    private int computeMargin(int max, double percent) {
        return (int)((double)max * percent);
    }

    private void computeMaxPageWidth() {
        this.maxPageWidth = PageSetup.size(PageSetup.inches(this.pageSetup.getDimension().getWidth()), this.printParameters.getPrinter().getDPI().x);
    }

    private int computeHeightForPage(int pageIndex) {
        int numberOfPages = this.numberOfPages();
        int height = this.maxPageHeight;
        if (numberOfPages == 1) {
            height = this.imageData.height;
        } else if (pageIndex == numberOfPages - 1) {
            height = this.imageData.height % this.maxPageHeight;
        }
        return height;
    }

    @Override
    public void printPage(final int page) {
        ImageHeightBoundsForPage bounds = this.heightBounds[page];
        final int srcY = bounds.getScr();
        final int srcHeight = bounds.getDest();
        final int destHeight = bounds.getSize();
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Image printImage = new Image((Device)PrintAsImageCallback.this.printParameters.getPrinter(), PrintAsImageCallback.this.imageData);
                GC printGC = new GC((Drawable)PrintAsImageCallback.this.printParameters.getPrinter());
                Rectangle trim = PrintAsImageCallback.this.printParameters.getTrim();
                printGC.drawImage(printImage, 0, srcY, ((PrintAsImageCallback)PrintAsImageCallback.this).imageData.width, srcHeight, -trim.x, -trim.y + PrintAsImageCallback.this.headerMargin, (int)(PrintAsImageCallback.this.scaleFactor * (double)((PrintAsImageCallback)PrintAsImageCallback.this).imageData.width), (int)(PrintAsImageCallback.this.scaleFactor * (double)destHeight));
                this.drawFooters(printGC, page + 1);
                printGC.dispose();
                printImage.dispose();
            }

            private void drawFooters(GC gc, int page2) {
                Color black = VisualBindingManager.getDefault().getColorFromName(SystemColors.BLACK_LITERAL.getName());
                gc.setForeground(black);
                Rectangle trim = PrintAsImageCallback.this.printParameters.getTrim();
                gc.drawLine(-trim.x, PrintAsImageCallback.this.maxPageHeight + PrintAsImageCallback.this.headerMargin + 1, PrintAsImageCallback.this.maxPageWidth, PrintAsImageCallback.this.maxPageHeight + PrintAsImageCallback.this.headerMargin + 1);
                gc.drawText(MessageFormat.format(Messages.PrintAsImageCallback_pageFooter, page2, PrintAsImageCallback.this.numberOfPages()), -trim.x, PrintAsImageCallback.this.maxPageHeight + PrintAsImageCallback.this.headerMargin + 5);
            }
        });
    }

    public void dispose() {
        this.imageToPrint.dispose();
    }

    private static class ImageHeightBoundsForPage {
        private int scr;
        private int dest;
        private int size;

        public ImageHeightBoundsForPage(int src, int dest) {
            this.scr = src;
            this.dest = dest;
            this.size = dest - src;
        }

        public int getScr() {
            return this.scr;
        }

        public int getDest() {
            return this.dest;
        }

        public int getSize() {
            return this.size;
        }
    }
}

