/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.PreRefreshStatus;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.CreatedTreeItem;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.OutputTreeItemDescriptor;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeMappingProvider;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;

class DTreePreRefreshStatus
implements PreRefreshStatus {
    private TreeMappingProvider provider;
    private Option<List<CreatedOutput>> computedOutputs;
    private GlobalContext ctx;

    DTreePreRefreshStatus(GlobalContext ctx, TreeMappingProvider provider) {
        this.provider = provider;
        this.computedOutputs = Options.newNone();
        this.ctx = ctx;
    }

    public Iterable<CreatedOutput> getExistingOutputs() {
        if (this.computedOutputs.some()) {
            return (Iterable)this.computedOutputs.get();
        }
        return Lists.newArrayList();
    }

    public void computeStatus(CreatedOutput container, Collection<? extends Mapping> childMappings) {
        ArrayList result = Lists.newArrayList();
        int i = 0;
        DTreeItemContainer viewContainer = (DTreeItemContainer)container.getCreatedElement();
        for (DTreeItem cur : viewContainer.getOwnedTreeItems()) {
            OutputTreeItemDescriptor descriptor = new OutputTreeItemDescriptor((DTreeItemContainer)container.getCreatedElement(), cur.getTarget(), cur.getActualMapping(), i, this.provider);
            CreatedTreeItem newOuput = new CreatedTreeItem(this.ctx, cur, descriptor);
            result.add(newOuput);
            ++i;
        }
        this.computedOutputs = Options.newSome((Object)result);
    }
}

