/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public final class SiriusContext {
    private Object input;
    private final Session session;
    private final DRepresentation representation;
    private final DSemanticDecorator semanticDecorator;
    private final EObject mainSemanticElement;

    private SiriusContext(Object input, Session session, DRepresentation representation, DSemanticDecorator semanticDecorator, EObject mainSemanticElement) {
        this.input = input;
        this.session = session;
        this.representation = representation;
        this.semanticDecorator = semanticDecorator;
        this.mainSemanticElement = mainSemanticElement;
    }

    public static SiriusContext from(Object input) {
        Object adapted;
        SiriusContext result = new SiriusContext(input, null, null, null, null);
        if (input instanceof Session) {
            result = SiriusContext.fromSession((Session)input);
        } else if (input instanceof DRepresentation) {
            result = SiriusContext.fromDRepresentation((DRepresentation)input);
        } else if (input instanceof DRepresentationElement) {
            result = SiriusContext.fromDRepresentationElement((DRepresentationElement)input);
        } else if (input instanceof EObject) {
            result = SiriusContext.fromUnknownEObject((EObject)input);
        } else if (input instanceof IAdaptable && (adapted = ((IAdaptable)input).getAdapter(EObject.class)) instanceof EObject) {
            result = SiriusContext.from((EObject)adapted);
            result.input = input;
        }
        return result;
    }

    private static SiriusContext fromSession(Session session) {
        return new SiriusContext(session, session, null, null, null);
    }

    private static SiriusContext fromDRepresentation(DRepresentation repr) {
        Session session = new EObjectQuery((EObject)repr).getSession();
        DSemanticDecorator decorator = null;
        if (repr instanceof DSemanticDecorator) {
            decorator = (DSemanticDecorator)repr;
        }
        EObject mainSemanticElement = null;
        if (decorator != null) {
            mainSemanticElement = decorator.getTarget();
        }
        return new SiriusContext(repr, session, repr, decorator, mainSemanticElement);
    }

    private static SiriusContext fromDRepresentationElement(DRepresentationElement dre) {
        Session session = new EObjectQuery((EObject)dre).getSession();
        Option repr = new EObjectQuery((EObject)dre).getRepresentation();
        return new SiriusContext(dre, session, (DRepresentation)repr.get(), (DSemanticDecorator)dre, dre.getTarget());
    }

    private static SiriusContext fromUnknownEObject(EObject obj) {
        Session session = SessionManager.INSTANCE.getSession(obj);
        Resource res = EcoreUtil.getRootContainer((EObject)obj).eResource();
        EObject semanticElement = null;
        if (session != null && res != null && session.getSemanticResources().contains(res)) {
            semanticElement = obj;
        }
        return new SiriusContext(obj, session, null, null, semanticElement);
    }

    public Object getInput() {
        return this.input;
    }

    public Option<Session> getSession() {
        return Options.fromNullable((Object)this.session);
    }

    public Option<DRepresentation> getDRepresentation() {
        return Options.fromNullable((Object)this.representation);
    }

    public DSemanticDecorator getSemanticDecorator() {
        return this.semanticDecorator;
    }

    public Option<EObject> getMainSemanticElement() {
        if (this.semanticDecorator != null) {
            return Options.newSome((Object)this.semanticDecorator.getTarget());
        }
        return Options.newSome((Object)this.mainSemanticElement);
    }

    public Option<Collection<EObject>> getAdditionalSemanticElements() {
        if (this.semanticDecorator instanceof DRepresentationElement) {
            return Options.newSome((Object)((DRepresentationElement)this.semanticDecorator).getSemanticElements());
        }
        return Options.newNone();
    }
}

