/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.tabprovider;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.EEFViewFactory;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.IEEFDomainClassTester;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.eef.ide.ui.properties.api.EEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptorProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.common.interpreter.api.VariableManagerFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.ui.properties.internal.Messages;
import org.eclipse.sirius.ui.properties.internal.SiriusInputDescriptor;
import org.eclipse.sirius.ui.properties.internal.SiriusInterpreter;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;
import org.eclipse.sirius.ui.properties.internal.TransactionalEditingDomainContextAdapter;
import org.eclipse.sirius.ui.properties.internal.tabprovider.ViewDescriptionConverter;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IWorkbenchPart;

public class SiriusTabDescriptorProvider
implements IEEFTabDescriptorProvider {
    private static final URI DEFAULT_PROPERTIES_URI = URI.createURI((String)"platform:/plugin/org.eclipse.sirius.ui.properties/model/properties.xmi", (boolean)true);
    private static final ResourceSet DEFAULT_RULES = new ResourceSetImpl();

    public static ViewExtensionDescription getDefaultRules() {
        Resource resource = DEFAULT_RULES.getResource(DEFAULT_PROPERTIES_URI, true);
        if (resource == null) {
            SiriusUIPropertiesPlugin.getPlugin().error(Messages.SiriusTabDescriptorProvider_DefaultPropertiesNotFound);
        } else {
            EList contents = resource.getContents();
            if (contents.size() > 0 && contents.get(0) instanceof ViewExtensionDescription) {
                return (ViewExtensionDescription)contents.get(0);
            }
        }
        return null;
    }

    public Collection<IEEFTabDescriptor> get(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object[] objects;
        if (selection instanceof IStructuredSelection && (objects = (structuredSelection = (IStructuredSelection)selection).toArray()).length > 0) {
            SiriusInputDescriptor sid;
            if (objects.length > 1) {
                SiriusUIPropertiesPlugin.getPlugin().warning(Messages.SiriusTabDescriptorProvider_UnsupportedMultipleSelection);
            }
            if ((sid = new SiriusInputDescriptor(objects[0])).getSemanticElement() != null) {
                return this.getTabDescriptors(sid);
            }
        }
        return new ArrayList<IEEFTabDescriptor>();
    }

    private Collection<IEEFTabDescriptor> getTabDescriptors(SiriusInputDescriptor input) {
        Session session = (Session)input.getFullContext().getSession().get();
        List<PageDescription> effectivePageDescriptions = this.computeEffectiveDescription(input, session);
        return this.getTabDescriptors(session, input, effectivePageDescriptions);
    }

    private Collection<IEEFTabDescriptor> getTabDescriptors(Session session, SiriusInputDescriptor input, List<PageDescription> effectivePageDescriptions) {
        EEFViewDescription viewDescription = new ViewDescriptionConverter(effectivePageDescriptions).convert(input);
        EEFView eefView = this.createEEFView(session, input, viewDescription);
        ArrayList<IEEFTabDescriptor> descriptors = new ArrayList<IEEFTabDescriptor>();
        List eefPages = eefView.getPages();
        for (EEFPage eefPage : eefPages) {
            descriptors.add((IEEFTabDescriptor)new EEFTabDescriptor(eefPage));
        }
        return descriptors;
    }

    private EEFView createEEFView(final Session session, SiriusInputDescriptor input, EEFViewDescription viewDescription) {
        IVariableManager variableManager = new VariableManagerFactory().createVariableManager();
        variableManager.put("self", (Object)input.getSemanticElement());
        variableManager.put("input", (Object)input);
        TransactionalEditingDomainContextAdapter eca = new TransactionalEditingDomainContextAdapter(session.getTransactionalEditingDomain());
        EEFView eefView = new EEFViewFactory().createEEFView(viewDescription, variableManager, (IInterpreter)new SiriusInterpreter(session), (EditingContextAdapter)eca, new IEEFDomainClassTester(){

            public boolean eInstanceOf(EObject eObject, String domainClass) {
                return Util.isBlank((String)domainClass) || session.getModelAccessor().eInstanceOf(eObject, domainClass);
            }
        }, (InputDescriptor)input);
        return eefView;
    }

    private List<PageDescription> computeEffectiveDescription(SiriusInputDescriptor input, Session session) {
        Preconditions.checkNotNull((Object)session);
        LinkedHashSet viewDescriptions = Sets.newLinkedHashSet();
        for (Viewpoint viewpoint : session.getSelectedViewpoints(true)) {
            Option parent = new EObjectQuery((EObject)viewpoint).getFirstAncestorOfType(DescriptionPackage.Literals.GROUP);
            if (!parent.some()) continue;
            Group group = (Group)parent.get();
            Iterables.addAll((Collection)viewDescriptions, (Iterable)Iterables.filter((Iterable)group.getExtensions(), ViewExtensionDescription.class));
        }
        ArrayList effectivePages = Lists.newArrayList();
        for (ViewExtensionDescription ved : viewDescriptions) {
            effectivePages.addAll(ved.getPages());
        }
        if (effectivePages.size() == 0) {
            ViewExtensionDescription viewExtensionDescription = SiriusTabDescriptorProvider.getDefaultRules();
            if (viewExtensionDescription != null) {
                effectivePages.addAll(viewExtensionDescription.getPages());
            } else {
                SiriusUIPropertiesPlugin.getPlugin().error(Messages.SiriusTabDescriptorProvider_DefaultPropertiesNotFound);
            }
        }
        return effectivePages;
    }
}

