/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.dialect.editor;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.sirius.business.internal.session.danalysis.DanglingRefRemovalTrigger;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DialectEditorCloserFilter
extends NotificationFilter.Custom {
    private DRepresentation dRepresentation;

    public DialectEditorCloserFilter(DRepresentation dRepresentation) {
        this.dRepresentation = dRepresentation;
    }

    public boolean matches(Notification notification) {
        return this.isTargetUnset(notification) || this.isRepresentationDeletion(notification) || this.isTargetDetachment(notification);
    }

    private boolean isTargetUnset(Notification notification) {
        boolean remove;
        boolean bl = remove = notification.getEventType() == 4 || notification.getEventType() == 2;
        return remove && notification.getNotifier() == this.dRepresentation && notification.getFeature() == ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET;
    }

    private boolean isRepresentationDeletion(Notification notification) {
        boolean representationDeleted = false;
        if (notification.getFeature() == ViewpointPackage.Literals.DVIEW__OWNED_REPRESENTATIONS && this.wasInOldValue(notification, (EObject)this.dRepresentation)) {
            representationDeleted = !(this.dRepresentation.eContainer() instanceof DView);
        } else if (notification.getFeature() == ViewpointPackage.Literals.DANALYSIS__OWNED_VIEWS && this.wasInOldValue(notification, this.dRepresentation.eContainer())) {
            representationDeleted = this.dRepresentation.eContainer() == null || this.dRepresentation.eContainer() == null || !(this.dRepresentation.eContainer().eContainer() instanceof DView);
        }
        return representationDeleted;
    }

    private boolean wasInOldValue(Notification notification, EObject eObject) {
        boolean isCurrentDRepresentationRemove = false;
        int eventType = notification.getEventType();
        if (eventType == 4 || eventType == 2 || eventType == 6) {
            isCurrentDRepresentationRemove = this.isInOldValue(notification, eObject);
        }
        return isCurrentDRepresentationRemove;
    }

    private boolean isInOldValue(Notification notification, EObject obj) {
        if (notification.getOldValue() instanceof Collection) {
            return ((Collection)notification.getOldValue()).contains(obj);
        }
        return notification.getOldValue() == obj;
    }

    private boolean isTargetDetachment(Notification notification) {
        boolean detachedTarget = false;
        if (DanglingRefRemovalTrigger.IS_DETACHMENT.apply((Object)notification) && this.dRepresentation instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)this.dRepresentation).getTarget();
            detachedTarget = this.isInOldValue(notification, target) && target.eContainer() == null;
        }
        return detachedTarget;
    }
}

