/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stardust.ide.simulation.ui.curves.draw2d.AbstractOverlayFigure;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.ColorUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;

public class OverlayGlassFrameFigure
extends AbstractOverlayFigure {
    int shadowOffset = 4;
    int surplus;
    RGB background;
    RGB shadow;

    public OverlayGlassFrameFigure(Configuration configuration, int surplus, RGB background, RGB shadow) {
        super(configuration);
        this.surplus = surplus;
        this.shadowOffset = surplus / 2;
        this.background = background;
        this.shadow = shadow;
    }

    public Insets getInsets() {
        return new Insets(this.surplus, this.surplus, this.surplus + this.shadowOffset, this.surplus + this.shadowOffset).add(super.getInsets());
    }

    protected void paintFigure(Graphics gc) {
        try {
            gc.pushState();
            Rectangle bounds = this.getBounds();
            gc.translate(this.getBounds().x, this.getBounds().y);
            if (this.shadow != null) {
                this.fillGradient(gc, new Rectangle(bounds.x + this.shadowOffset, bounds.y + this.shadowOffset, bounds.width - this.shadowOffset, bounds.height - this.shadowOffset), this.surplus, this.configuration.getColorObject(this.shadow), this.configuration.getShadowPattern(this.shadow, bounds.width, bounds.height));
            }
            this.fillGradient(gc, new Rectangle(bounds.x, bounds.y, bounds.width - this.shadowOffset - 1, bounds.height - this.shadowOffset - 1), this.surplus, this.configuration.getColorObject(this.background), this.configuration.getGradientPattern(this.background, bounds.width, bounds.height));
            gc.setForegroundColor(this.configuration.getTextColorObject());
            gc.drawRoundRectangle(new Rectangle(bounds.x, bounds.y, bounds.width - this.shadowOffset - 1, bounds.height - this.shadowOffset - 1), this.surplus * 2, this.surplus * 2);
            gc.popState();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void fillGradient(Graphics gc, Rectangle rectangle, int rounding, Color bg, Pattern pattern) {
        boolean supportBackgroundPattern = true;
        try {
            if (gc instanceof ScaledGraphics) {
                supportBackgroundPattern = false;
            } else {
                gc.setBackgroundColor(bg);
                gc.setBackgroundPattern(pattern);
                gc.fillRoundRectangle(rectangle, rounding * 2, rounding * 2);
            }
        }
        catch (RuntimeException runtimeException) {
            supportBackgroundPattern = false;
        }
        if (!supportBackgroundPattern) {
            gc.setBackgroundColor(bg);
            gc.setForegroundColor(this.configuration.getColorObject(ColorUtils.brighter(bg, 2)));
            gc.fillGradient(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
        }
    }
}

