/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.editor;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DynamicData;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.SelectionProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2DList;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;

public class EditableDataProvider
implements DataProvider,
DynamicData,
SelectionProvider {
    Coord2DList points;
    Set selection = new LinkedHashSet();

    public EditableDataProvider(Coord2D[] points) {
        this.points = new Coord2DList(points);
    }

    public EditableDataProvider(DataProvider initializer) {
        this.points = new Coord2DList(initializer.getPoints());
    }

    @Override
    public Coord2D[] getPoints() {
        return this.points.toArray();
    }

    public Coord2D findNearestPoint(Coord2D point, boolean unselectedOnly) {
        TreeMap<Double, Coord2D> map = new TreeMap<Double, Coord2D>();
        int i = 0;
        while (i < this.points.size()) {
            if (!unselectedOnly || !this.isSelection(point)) {
                map.put(new Double(point.distance(this.points.get(i))), this.points.get(i));
            }
            ++i;
        }
        return map.isEmpty() ? null : (Coord2D)map.get(map.firstKey());
    }

    public Coord2D isNear(Coord2D point, boolean unselectedOnly, Rectangle2D sensivity) {
        Coord2D found = this.findNearestPoint(point, unselectedOnly);
        if (found != null && sensivity.inside(found.minus(point))) {
            return found;
        }
        return null;
    }

    public Coord2D[] findPath(Coord2D c1, Coord2D c2) {
        Coord2DList result = new Coord2DList();
        boolean between = false;
        Iterator itr = this.points.iterator();
        while (itr.hasNext()) {
            Coord2D c = (Coord2D)itr.next();
            if (c == c1 || c == c2) {
                between = !between;
                result.add(c);
                continue;
            }
            if (!between) continue;
            result.add(c);
        }
        return result.toArray();
    }

    public Coord2D[] findNeighbourhood(double d) {
        if (d < this.points.getFirst().getX()) {
            Coord2D[] coord2DArray = new Coord2D[2];
            coord2DArray[1] = this.points.getFirst();
            return coord2DArray;
        }
        if (d > this.points.getLast().getX()) {
            Coord2D[] coord2DArray = new Coord2D[2];
            coord2DArray[0] = this.points.getLast();
            return coord2DArray;
        }
        int i = 1;
        while (i < this.points.size()) {
            if (this.points.get(i - 1).getX() <= d && d <= this.points.get(i).getX()) {
                return new Coord2D[]{this.points.get(i - 1), this.points.get(i)};
            }
            ++i;
        }
        throw new RuntimeException("internal error");
    }

    public void insertPointAfter(Coord2D c, Coord2D n) {
        if (c == null) {
            this.points.add(0, n);
        } else {
            boolean done = false;
            int i = 0;
            while (i < this.points.size()) {
                if (this.points.get(i) == c) {
                    this.points.add(i, n);
                    done = true;
                }
                ++i;
            }
            if (!done) {
                this.points.add(n);
            }
        }
    }

    public void deletePoint(Coord2D c) {
        this.points.remove(c);
    }

    public void clearSelection() {
        this.selection.clear();
    }

    public void setSelection(Coord2D point) {
        this.selection.clear();
        this.selection.add(point);
    }

    public void addSelection(Coord2D point) {
        if (this.isEmptySelection()) {
            this.selection.add(point);
        } else if (!this.isSelection(point)) {
            Coord2DList temp = new Coord2DList(this.selection);
            this.selection.clear();
            Coord2D[] path = this.findPath(temp.getFirst(), point);
            int i = 0;
            while (i < path.length) {
                if (!this.isSelection(path[i])) {
                    this.selection.add(path[i]);
                }
                ++i;
            }
            path = this.findPath(point, temp.getLast());
            i = 0;
            while (i < path.length) {
                if (!this.isSelection(path[i])) {
                    this.selection.add(path[i]);
                }
                ++i;
            }
        }
    }

    public boolean isSelection(Coord2D point) {
        return this.selection.contains(point);
    }

    public boolean isSelection(int index) {
        return this.selection.contains(this.points.get(index));
    }

    public boolean isEmptySelection() {
        return this.selection.isEmpty();
    }

    @Override
    public Coord2D[] getSelection() {
        return this.selection.toArray(new Coord2D[this.selection.size()]);
    }

    public Coord2D adjustSelectionConstraints(Coord2D distance) {
        double left = Double.MAX_VALUE;
        double right = Double.MAX_VALUE;
        int i = 0;
        while (i < this.points.size()) {
            if (i > 0 && this.isSelection(i) && !this.isSelection(i - 1)) {
                left = Math.min(left, Math.abs(this.points.get(i).getX() - this.points.get(i - 1).getX()));
            }
            if (i < this.points.size() - 1 && this.isSelection(i) && !this.isSelection(i + 1)) {
                right = Math.min(right, Math.abs(this.points.get(i).getX() - this.points.get(i + 1).getX()));
            }
            ++i;
        }
        return new Rectangle2D(new Coord2D(-left, -1.7976931348623157E308), new Coord2D(right, Double.MAX_VALUE)).adjust(distance);
    }

    public void replacePoints(Coord2D[] oldPoints, Coord2D[] newPoints) {
        int i = 0;
        while (i < oldPoints.length) {
            this.points.replace(oldPoints[i], newPoints[i]);
            ++i;
        }
    }

    public String toString() {
        StringBuffer builder = new StringBuffer("curve: ");
        Iterator itr = this.points.iterator();
        if (itr.hasNext()) {
            builder.append(itr.next());
            while (itr.hasNext()) {
                builder.append(", ").append(itr.next());
            }
        }
        return builder.toString();
    }
}

