/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.functions;

import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDoubleFunction;

public class PoissonDistribution
implements DataProviderForDoubleFunction.Function {
    double lambda;
    double elambda;

    public PoissonDistribution(double lambda) {
        this.lambda = lambda;
        this.elambda = Math.exp(-lambda);
    }

    @Override
    public double f(double x) {
        int i = (int)Math.round(x);
        return this.f(i);
    }

    public double f(int i) {
        return i >= 0 ? Math.pow(this.lambda, i) * this.elambda / this.factorial(i) : 0.0;
    }

    private double factorial(int x) {
        return x < 2 ? 1.0 : (double)x * this.factorial(x - 1);
    }

    public String toString() {
        return "\u03bb = " + this.lambda;
    }
}

