/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StaticAxisLabeling;

public class DefaultDynamicAxisLabeling
extends StaticAxisLabeling {
    private static double[] DIVIDER = new double[]{1.0, 2.0, 5.0, 10.0, 100.0};
    private static int MIN_SPACE = 20;

    public DefaultDynamicAxisLabeling(String scaleFormat) {
        super(0.0, 0.0, 0.0, scaleFormat);
    }

    public DefaultDynamicAxisLabeling() {
        super(0.0, 0.0, 0.0, null);
    }

    @Override
    public void update(double diffInValues, int diffInPixel) {
        int precison = (int)Math.floor(Math.log(diffInValues) / Math.log(10.0));
        if (precison > 0) {
            int i;
            this.scaleFormat = new DecimalFormat("#", new DecimalFormatSymbols(Locale.US));
            this.scaleTicks = this.largeTicks = Math.pow(10.0, precison);
            int numOfLargeTicks = (int)Math.max(1.0, Math.floor(diffInValues / this.largeTicks));
            if (diffInValues < 2.0 * this.largeTicks) {
                this.largeTicks /= 2.0;
                numOfLargeTicks *= 2;
            } else {
                i = DIVIDER.length - 1;
                while (i >= 0) {
                    if ((double)diffInPixel / ((double)numOfLargeTicks / DIVIDER[i]) > (double)MIN_SPACE) {
                        this.scaleTicks = this.largeTicks * DIVIDER[i];
                    }
                    --i;
                }
            }
            this.smallTicks = 0.0;
            i = 0;
            while (i < DIVIDER.length) {
                if ((double)diffInPixel / ((double)numOfLargeTicks * DIVIDER[i]) > (double)MIN_SPACE) {
                    this.smallTicks = this.largeTicks / DIVIDER[i];
                }
                ++i;
            }
        } else if (precison > 0) {
            this.scaleFormat = new DecimalFormat("#.####################".substring(0, precison + 2), new DecimalFormatSymbols(Locale.US));
            this.scaleTicks = this.largeTicks = Math.pow(10.0, precison);
            this.smallTicks = Math.pow(10.0, precison - 1);
        }
    }
}

