/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayer;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayerBase;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public class FilledCurveLayer
extends CurveLayerBase {
    RGB white = new RGB(255, 255, 255);

    public FilledCurveLayer(DataProvider provider, int curveNr) {
        super(provider, curveNr);
    }

    public FilledCurveLayer(DataProvider provider, RGB color) {
        super(provider, color);
    }

    public FilledCurveLayer(DataProvider provider) {
        super(provider);
    }

    public FilledCurveLayer(CurveLayer wrapped) {
        super(wrapped);
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        super.draw(gc, metrics, configuration);
        if (this.getCoords().length > 0) {
            gc.pushState();
            Point ground = Coord2D.model2swt(metrics.transposeToCanvas(new Coord2D(0.0, 0.0)));
            Point[] points = Coord2D.model2swt(metrics.transposeToCanvas(this.getCoords()));
            gc.setBackgroundColor(this.getColor(configuration));
            Point prev = points[0];
            int i = 1;
            while (i < points.length) {
                this.drawFill(gc, ground, i - 1, prev, i, points[i]);
                prev = points[i];
                ++i;
            }
            gc.popState();
        }
    }

    protected void drawFill(Graphics gc, Point ground, int index0, Point point0, int index1, Point point1) {
        PointList path = new PointList();
        path.addPoint(point0.x, ground.y);
        path.addPoint(point0.x, point0.y);
        path.addPoint(point1.x, point1.y);
        path.addPoint(point1.x, ground.y);
        gc.drawPolygon(path);
    }
}

