/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StaticAxisLabeling;

public class OldTimeAxisLabeling
extends StaticAxisLabeling {
    int timeUnit = 14;

    public OldTimeAxisLabeling(int timeUnit) {
        super(0.0, 0.0, 0.0, null);
        this.timeUnit = timeUnit;
    }

    @Override
    public void update(double diffInValues, int diffInPixel) {
        this.largeTicks = OldTimeAxisLabeling.getMaxTimelineValue(this.timeUnit);
        switch (this.timeUnit) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                this.smallTicks = 1.0;
                this.scaleFormat = new DecimalFormat("#", new DecimalFormatSymbols(Locale.US));
                break;
            }
            case 13: {
                this.smallTicks = 10.0;
                this.scaleFormat = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.US));
                break;
            }
            case 12: {
                this.smallTicks = 10.0;
                this.scaleFormat = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.US));
                break;
            }
            default: {
                this.smallTicks = 100.0;
                this.scaleFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
            }
        }
        double resolution = (double)diffInPixel * this.smallTicks / diffInValues;
        while (resolution < 30.0) {
            this.smallTicks *= 2.0;
            resolution = (double)diffInPixel * this.smallTicks / diffInValues;
        }
        this.scaleTicks = diffInValues > this.largeTicks ? this.largeTicks : this.smallTicks;
    }

    public static double getMaxTimelineValue(int timeUnit) {
        switch (timeUnit) {
            case 6: {
                return 365.0;
            }
            case 3: {
                return 52.0;
            }
            case 7: {
                return 7.0;
            }
            case 2: {
                return 12.0;
            }
            case 10: 
            case 11: {
                return 24.0;
            }
            case 12: {
                return 60.0;
            }
            case 13: {
                return 60.0;
            }
        }
        return 1000.0;
    }
}

