/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProvider;
import org.eclipse.stardust.ide.simulation.ui.curves.data.DiscreteIntegral;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.CurveLayerBase;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.ColorUtils;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.GCDrawingUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class ProbabilityAreasLayer
extends CurveLayerBase {
    DecimalFormat scaleFormat = new DecimalFormat("###'%'", new DecimalFormatSymbols(Locale.US));
    DiscreteIntegral integral;

    public ProbabilityAreasLayer(DiscreteIntegral integral, int curveNr) {
        super((DataProvider)integral, curveNr);
        this.integral = integral;
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        super.draw(gc, metrics, configuration);
        if (this.getCoords().length > 0) {
            gc.pushState();
            Point ground = Coord2D.model2swt(metrics.transposeToCanvas(new Coord2D(0.0, 0.0)));
            Point[] points = Coord2D.model2swt(metrics.transposeToCanvas(this.getCoords()));
            Color c1 = configuration.getColorObject(ColorUtils.brighter(this.getColor(configuration), 3));
            Color c2 = this.getColor(configuration);
            GCDrawingUtils gcutils = new GCDrawingUtils(gc);
            double F = this.integral.getIntegral();
            int i = 1;
            while (i < points.length) {
                Point prev = points[i - 1];
                Point curr = points[i];
                Point avrg = new Point((curr.x + prev.x) / 2, (curr.y + prev.y) / 2);
                double f = this.integral.getIntegral(i - 1, i);
                gc.setForegroundColor(c1);
                this.drawFill(gc, ground, i - 1, prev, i, points[i]);
                double pcent = 100.0 * f / F;
                if (pcent > 1.0) {
                    gc.setForegroundColor(c2);
                    gcutils.drawText(this.scaleFormat.format(pcent), prev.x, avrg.y, curr.x - prev.x, ground.y - avrg.y);
                }
                i += 2;
            }
            gc.popState();
        }
    }

    protected void drawFill(Graphics gc, Point ground, int index0, Point point0, int index1, Point point1) {
        gc.setLineStyle(3);
        PointList path = new PointList();
        path.addPoint(point0.x, ground.y);
        path.addPoint(point0.x, point0.y);
        path.addPoint(point1.x, point1.y);
        path.addPoint(point1.x, ground.y);
        gc.drawPolygon(path);
    }
}

