/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.swtutil;

import java.util.ArrayList;
import java.util.Calendar;

public class TimelineUtils {
    public static int getMaxValue(int timeUnit) {
        switch (timeUnit) {
            case 6: {
                return 365;
            }
            case 3: {
                return 52;
            }
            case 7: {
                return 7;
            }
            case 2: {
                return 12;
            }
            case 11: {
                return 24;
            }
            case 10: {
                return 1;
            }
            case 12: {
                return 1;
            }
            case 13: {
                return 1;
            }
        }
        return 1;
    }

    public static int getTicker(int timeUnit) {
        switch (timeUnit) {
            case 6: {
                return 6;
            }
            case 3: {
                return 3;
            }
            case 7: {
                return 7;
            }
            case 11: {
                return 10;
            }
            case 2: {
                return 5;
            }
            case 10: {
                return 12;
            }
            case 12: {
                return 13;
            }
        }
        return 14;
    }

    public static int[] getMarkerValues(int timeUnit, Calendar start) {
        switch (timeUnit) {
            case 6: {
                return TimelineUtils.iterateMarkerValues(6, 2, 1, 1, start);
            }
            case 3: {
                return TimelineUtils.iterateMarkerValues(3, 2, 1, 1, start);
            }
            case 7: {
                return TimelineUtils.iterateMarkerValues(7, 7, 1, 3, start);
            }
            case 11: {
                return TimelineUtils.iterateMarkerValues(10, 10, 8, 6, start);
            }
            case 2: {
                return TimelineUtils.iterateMarkerValues(5, 4, 1, 2, start);
            }
            case 10: {
                return TimelineUtils.iterateMarkerValues(12, 12, 15, 6, start);
            }
            case 12: {
                return TimelineUtils.iterateMarkerValues(13, 13, 15, 12, start);
            }
            case 13: {
                return TimelineUtils.iterateMarkerValues(14, 14, 100, 12, start);
            }
        }
        return new int[0];
    }

    public static Calendar reset(int timeUnit, Calendar calendar) {
        switch (timeUnit) {
            case 3: 
            case 6: {
                calendar.set(6, 1);
            }
            case 7: {
                calendar.set(7, 1);
            }
            case 2: {
                calendar.set(2, 0);
            }
            case 10: {
                calendar.set(10, 0);
            }
            case 11: {
                calendar.set(11, 0);
            }
            case 12: {
                calendar.set(12, 0);
            }
            case 13: {
                calendar.set(13, 0);
            }
        }
        return calendar;
    }

    private static int[] iterateMarkerValues(int increment, int page, int pageIncrement, int range, Calendar start) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int endValue = 1 + start.get(range);
        int fireValue = pageIncrement + start.get(page);
        while (start.get(range) != endValue) {
            int returnValue = start.get(increment);
            start.add(increment, 1);
            if (page == increment) {
                returnValue = start.get(increment);
            }
            if (start.get(page) != fireValue) continue;
            list.add(new Integer(returnValue));
            fireValue += pageIncrement;
        }
        int[] result = new int[list.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)list.get(i);
            ++i;
        }
        return result;
    }

    public static void test(String label, int timeUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar = TimelineUtils.reset(timeUnit, calendar);
        System.out.println("=== " + label);
        System.out.println("" + calendar.getTime());
        System.out.println("MAX: " + TimelineUtils.getMaxValue(timeUnit));
        System.out.println("TICKER: " + TimelineUtils.getTicker(timeUnit));
        System.out.println("MARKER: ");
        int[] marker = TimelineUtils.getMarkerValues(timeUnit, calendar);
        int i = 0;
        while (i < marker.length) {
            System.out.println("   " + marker[i]);
            ++i;
        }
        System.out.println("" + calendar.getTime());
    }

    public static void main(String[] args) {
        TimelineUtils.test("Day of Year", 6);
        TimelineUtils.test("Day of Week", 7);
        TimelineUtils.test("Hour of Day", 11);
        TimelineUtils.test("Hour", 10);
    }
}

