/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessAdapter;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessForMap;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessForModel;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;

public class SimulationConfigurationList {
    private AttributeAccessAdapter attributes;
    private SortedMap simulationConfigurations;
    private int currentConfigurationId;
    private int nextConfigurationId;

    public SimulationConfigurationList(Map attributeMap) {
        this(new AttributeAccessForMap(attributeMap, ""));
    }

    public SimulationConfigurationList(ModelType model) {
        this(new AttributeAccessForModel((IExtensibleElement)model, ""));
    }

    public SimulationConfigurationList(AttributeAccessAdapter attributes) {
        this.attributes = attributes;
        this.currentConfigurationId = Integer.parseInt(attributes.getAttibute("carnot:simulation:configuration:currentSimulationConfigurationId", "0"));
        this.nextConfigurationId = Integer.parseInt(attributes.getAttibute("carnot:simulation:configuration:nextSimulationConfigurationId", "1"));
        this.readSimulationConfigurationsFromModel();
    }

    public boolean hasConfigurations() {
        return this.simulationConfigurations.size() != 0;
    }

    public boolean hasConfiguration(int anyConfigurationId) {
        return this.simulationConfigurations.containsKey(new Integer(anyConfigurationId));
    }

    public SimulationConfiguration getCurrentConfiguration() {
        return (SimulationConfiguration)this.simulationConfigurations.get(new Integer(this.currentConfigurationId));
    }

    public int getCurrentConfigurationId() {
        return this.currentConfigurationId;
    }

    public String getCurrentConfigurationName() {
        return this.simulationConfigurations.containsKey(new Integer(this.currentConfigurationId)) ? ((SimulationConfiguration)this.simulationConfigurations.get(new Integer(this.currentConfigurationId))).getName() : null;
    }

    private void readSimulationConfigurationsFromModel() {
        this.simulationConfigurations = new TreeMap();
        List existingIds = this.readAllDefinedIds(this.attributes);
        for (Integer id : existingIds) {
            SimulationConfiguration simulationConfiguration = new SimulationConfiguration((int)id, this.attributes);
            this.simulationConfigurations.put(id, simulationConfiguration);
        }
    }

    private List readAllDefinedIds(AttributeAccessAdapter attributes) {
        String idList = attributes.getAttibute("carnot:simulation:configuration:simulationConfigurationIds", "");
        LinkedList<Integer> result = new LinkedList<Integer>();
        StringTokenizer st = new StringTokenizer(idList, ",");
        while (st.hasMoreTokens()) {
            result.add(new Integer(st.nextToken()));
        }
        return result;
    }

    private void deleteSimulationConfigurationsFromModel() {
        List existingIds = this.readAllDefinedIds(this.attributes);
        for (Integer id : existingIds) {
            String prefix = "carnot:simulation:configuration:simulationConfiguration[" + id + "].";
            this.attributes.setAttibute(String.valueOf(prefix) + "name", null);
            this.attributes.setAttibute(String.valueOf(prefix) + "description", null);
            this.attributes.setAttibute(String.valueOf(prefix) + "intervalStart", null);
            this.attributes.setAttibute(String.valueOf(prefix) + "intervalEnd", null);
        }
        this.attributes.setAttibute("carnot:simulation:configuration:currentSimulationConfigurationId", null);
    }

    public void writeSimulationConfigurationsToModel() {
        String idString = "";
        for (SimulationConfiguration simulationConfiguration : this.simulationConfigurations.values()) {
            idString = String.valueOf(idString) + simulationConfiguration.getId() + ",";
        }
        if (this.hasConfigurations()) {
            this.attributes.setAttibute("carnot:simulation:configuration:currentSimulationConfigurationId", String.valueOf(this.currentConfigurationId));
        } else {
            this.attributes.setAttibute("carnot:simulation:configuration:currentSimulationConfigurationId", null);
        }
        this.attributes.setAttibute("carnot:simulation:configuration:nextSimulationConfigurationId", String.valueOf(this.nextConfigurationId));
        this.attributes.setAttibute("carnot:simulation:configuration:simulationConfigurationIds", idString);
    }

    public void setCurrentSimulationConfiguration(SimulationConfiguration simulationConfiguration) {
        this.currentConfigurationId = simulationConfiguration.getId();
    }

    public List getAllConfigurations() {
        return Collections.unmodifiableList(new LinkedList(this.simulationConfigurations.values()));
    }

    public void remove(SimulationConfiguration simulationConfiguration) {
        boolean defaultDeleted = false;
        if (this.getCurrentConfigurationId() == simulationConfiguration.getId()) {
            defaultDeleted = true;
        }
        this.simulationConfigurations.remove(new Integer(simulationConfiguration.getId()));
        if (defaultDeleted && this.simulationConfigurations.size() > 0) {
            this.setCurrentSimulationConfiguration((SimulationConfiguration)this.simulationConfigurations.get(this.simulationConfigurations.lastKey()));
        }
    }

    public SimulationConfiguration create() {
        int id = this.nextConfigurationId++;
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(new Date());
        endDate.add(1, 1);
        SimulationConfiguration simulationConfiguration = new SimulationConfiguration(id, String.valueOf(Simulation_Modeling_Messages.SIMULATION_CONFIGURATION_DEFAULT_NAME) + id, String.valueOf(Simulation_Modeling_Messages.SIMULATION_CONFIGURATION_DEFAULT_DESCRIPTION) + id, new Date(), endDate.getTime());
        this.simulationConfigurations.put(new Integer(id), simulationConfiguration);
        this.setCurrentSimulationConfiguration(simulationConfiguration);
        return simulationConfiguration;
    }
}

