/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.audittrail;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueList;

public class AuditTrailEvaluatorDebug {
    static Map knownObjects = new TreeMap();

    public static void reset() {
        knownObjects = new TreeMap();
    }

    public static void addCurve(String objectId, String curveType, TimestampValueList curve) {
        AuditTrailEvaluatorDebug.addCurves(objectId, curveType, new TimestampValueList[]{curve});
    }

    public static void addCurves(String objectId, String curveType, TimestampValueList[] curve) {
        Map curveTypes;
        if (!knownObjects.containsKey(objectId)) {
            knownObjects.put(objectId, new LinkedHashMap());
        }
        if (!(curveTypes = (Map)knownObjects.get(objectId)).containsKey(curveType)) {
            curveTypes.put(curveType, new Vector());
        }
        Vector curves = (Vector)curveTypes.get(curveType);
        curves.addAll(Arrays.asList(curve));
    }

    public static String[] getKnownObjects() {
        return knownObjects.keySet().toArray(new String[knownObjects.size()]);
    }

    public static String[] getCurveTypes(String objectId) {
        Map curveTypes = (Map)knownObjects.get(objectId);
        if (curveTypes != null) {
            return curveTypes.keySet().toArray(new String[curveTypes.size()]);
        }
        return null;
    }

    public static TimestampValueList[] getCurves(String objectId, String curveType) {
        Map curveTypes = (Map)knownObjects.get(objectId);
        if (curveTypes != null) {
            Vector curves = (Vector)curveTypes.get(curveType);
            if (curves != null) {
                return curves.toArray(new TimestampValueList[curves.size()]);
            }
            return null;
        }
        return null;
    }
}

