/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions.junit;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;

public class AvailabilityConfigurationTest
extends TestCase {
    public AvailabilityConfigurationTest(String name) {
        super(name);
    }

    public void testReadWrite() throws Exception {
        int configurationId = 4711;
        Date startDate = new SimpleDateFormat("yyyyMMdd").parse("20010101");
        SimulationInterval intervalConfiguration = new SimulationInterval(startDate, new TimeCalculator(startDate).add(2, 1).toDate());
        AvailabilityConfiguration ac1 = new AvailabilityConfiguration(intervalConfiguration);
        ac1.read(new HashMap(), configurationId);
        LinkedHashMap m1 = new LinkedHashMap();
        ac1.write(m1, configurationId);
        this.checkDefaults(m1);
        AvailabilityConfiguration ac2 = new AvailabilityConfiguration(intervalConfiguration);
        ac2.read(m1, configurationId);
        LinkedHashMap m2 = new LinkedHashMap();
        ac2.write(m2, configurationId);
        this.checkDefaults(m2);
    }

    private void checkDefaults(Map m) {
        AvailabilityConfigurationTest.assertEquals((String)"false", (String)((String)m.get("carnot:simulation:configuration[4711]:availability:unlimited")));
        AvailabilityConfigurationTest.assertEquals((String)"false", (String)((String)m.get("carnot:simulation:configuration[4711]:fromAuditTrail")));
        AvailabilityConfigurationTest.assertEquals((String)"msec:[0;0.0][28800000;1.0][57600000;0.0][86400000;0.0]", (String)((String)m.get("carnot:simulation:configuration[4711]:availability:day")));
        AvailabilityConfigurationTest.assertEquals((String)"msec:[0;1.0][86400000;1.0][172800000;1.0][259200000;1.0][345600000;1.0][432000000;0.0][518400000;0.0][604800000;1.0][691200000;1.0][777600000;1.0][864000000;1.0][950400000;1.0][1036800000;0.0][1123200000;0.0][1209600000;1.0][1296000000;1.0][1382400000;1.0][1468800000;1.0][1555200000;1.0][1641600000;0.0][1728000000;0.0][1814400000;1.0][1900800000;1.0][1987200000;1.0][2073600000;1.0][2160000000;1.0][2246400000;0.0][2332800000;0.0][2419200000;1.0][2505600000;1.0][2592000000;1.0][2678400000;1.0]", (String)((String)m.get("carnot:simulation:configuration[4711]:availability:calendar")));
        AvailabilityConfigurationTest.assertEquals((String)"msec:[0;10.0][31536000000;10.0]", (String)((String)m.get("carnot:simulation:configuration[4711]:availability:year")));
        AvailabilityConfigurationTest.assertEquals((String)"org.eclipse.stardust.ide.simulation.ui.timeutils.standardholidays.SaturdayHolidays;org.eclipse.stardust.ide.simulation.ui.timeutils.standardholidays.SundayHolidays", (String)((String)m.get("carnot:simulation:configuration[4711]:availability:calendarbase")));
        AvailabilityConfigurationTest.assertEquals((String)"1.0", (String)((String)m.get("carnot:simulation:configuration[4711]:availability")));
        AvailabilityConfigurationTest.assertNull(m.get("carnot:simulation:configuration[4711]:availability:slider"));
    }
}

