/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.distributions.utils;

public class AdjustableDoubleRange {
    String label;
    double minValue;
    double maxValue;
    double increment;

    public AdjustableDoubleRange(String label, double minValue, double maxValue, double increment) {
        this.label = label;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.increment = increment;
    }

    public AdjustableDoubleRange(AdjustableDoubleRange master) {
        this.label = master.label;
        this.minValue = master.minValue;
        this.maxValue = master.maxValue;
        this.increment = master.increment;
    }

    public int doubleToInt(double value) {
        return (int)Math.round((value - this.minValue) / this.increment);
    }

    public double intToDouble(int index) {
        return Math.min(Math.max(this.minValue + this.increment * (double)index, this.minValue), this.maxValue);
    }

    public String getLabel() {
        return this.label;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getIncrement() {
        return this.increment;
    }

    public int getMinValueInt() {
        return 0;
    }

    public int getMaxValueInt() {
        return (int)Math.ceil((this.maxValue - this.minValue) / this.increment);
    }

    public String toString() {
        return AdjustableDoubleRange.toString(this);
    }

    public static String toString(AdjustableDoubleRange range) {
        return new StringBuffer().append(range.label).append(";").append(range.minValue).append(";").append(range.maxValue).append(";").append(range.increment).toString();
    }

    public static AdjustableDoubleRange fromString(String string) {
        String[] split = string.split(";", -1);
        return new AdjustableDoubleRange(split[0], Double.parseDouble(split[1]), Double.parseDouble(split[2]), Double.parseDouble(split[3]));
    }
}

