/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfigurationList;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AvailabilityPanel;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DefaultSimulationAvailabilityPropertyPage
extends AbstractModelElementPropertyPage {
    int configurationId = -1;
    AvailabilityPanel availabilityPanel;
    AvailabilityConfiguration configuration;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        SimulationConfigurationList configurationList = new SimulationConfigurationList(ModelUtils.findContainingModel((EObject)element));
        if (configurationList.hasConfigurations()) {
            SimulationConfiguration mainConfiguration = configurationList.getCurrentConfiguration();
            this.configurationId = configurationList.getCurrentConfigurationId();
            this.configuration = new AvailabilityConfiguration(mainConfiguration.getInterval());
            this.configuration.read((IExtensibleElement)element, this.configurationId);
            this.availabilityPanel.setConfiguration(this.configuration);
            this.availabilityPanel.setConfigurationEnabled(true);
            this.availabilityPanel.setConfigurationInfo(configurationList.getCurrentConfigurationName());
        } else {
            this.configurationId = -1;
            this.availabilityPanel.setConfigurationEnabled(false);
        }
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        if (this.configurationId >= 0) {
            this.configuration = this.availabilityPanel.getConfiguration();
            AdjustableDoubleRange multiplicatorSlider = this.availabilityPanel.getMultiplicatorSlider().getSliderRange();
            this.configuration.getMultiplicator().setRange(multiplicatorSlider);
            this.configuration.write((IExtensibleElement)element, this.configurationId);
        }
        SimulationModelUtils.fireNotificationEvent((EObject)element, (Object)this);
    }

    public Control createBody(Composite parent) {
        Composite mainComposite = FormBuilder.createComposite((Composite)parent, (int)2);
        Control specificBody = this.createPageSpecificBody(mainComposite);
        Control commonBody = this.createCommonBody(mainComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(mainComposite);
        if (specificBody != null) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(specificBody);
        }
        if (commonBody != null) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(700, -1).applyTo(commonBody);
        }
        return mainComposite;
    }

    public Control createPageSpecificBody(Composite parent) {
        return null;
    }

    public Control createCommonBody(Composite parent) {
        this.availabilityPanel = new AvailabilityPanel(parent, 0, Simulation_Modeling_Messages.UNLIMITED_AVAILABILITY, Simulation_Modeling_Messages.DAILY_AVAILABILITY, Simulation_Modeling_Messages.CALENDAR_AVAILABILITY, Simulation_Modeling_Messages.AVAILABLE_RESOURCE, 1);
        return this.availabilityPanel;
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void dispose() {
        this.availabilityPanel.dispose();
        super.dispose();
    }
}

