/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfigurationList;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.curves.editor.DragListener;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.distributions.ProbabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.MultiProbabilityPanel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.ProbabilityPanel;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class DefaultSimulationGatewayProbabilityPropertyPage
extends AbstractModelElementPropertyPage {
    TableViewer viewer;
    Table table;
    TransitionType selectedTransition;
    MultiProbabilityPanel probabilityPanel0;
    ProbabilityPanel probabilityPanel;
    int configurationId;
    Map configurations = new HashMap();

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.configurations = new HashMap();
        SimulationConfigurationList configurationList = new SimulationConfigurationList(ModelUtils.findContainingModel((EObject)element));
        if (configurationList.hasConfigurations()) {
            SimulationConfiguration configuration = configurationList.getCurrentConfiguration();
            this.configurationId = configuration.getId();
            this.probabilityPanel0.setConfigurationInfo(configurationList.getCurrentConfigurationName());
            GatewaySymbol gateway = (GatewaySymbol)element;
            for (TransitionConnectionType transitionConnection : gateway.getOutTransitions()) {
                TransitionType transition = transitionConnection.getTransition();
                ProbabilityConfiguration probability = new ProbabilityConfiguration(configuration.getInterval(), SimulationModelUtils.calculateDefaultProbability((IModelElement)transition));
                probability.read((IExtensibleElement)transition, this.configurationId);
                this.configurations.put(transition, probability);
            }
            this.viewer.setInput((Object)gateway);
            this.viewer.setContentProvider((IContentProvider)new TransitionContentProvider(gateway));
        }
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.updateSelection((TransitionType)null);
        GatewaySymbol gateway = (GatewaySymbol)element;
        for (TransitionConnectionType transitionConnection : gateway.getOutTransitions()) {
            TransitionType transition = transitionConnection.getTransition();
            ProbabilityConfiguration configuration = this.getConfiguration(transition);
            if (configuration == null) continue;
            configuration.write((IExtensibleElement)transition, this.configurationId);
        }
        SimulationModelUtils.fireNotificationEvent((EObject)element, (Object)this);
    }

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.probabilityPanel0 = new MultiProbabilityPanel(composite, 0);
        this.table = new Table(composite, 67584);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)250));
        FormBuilder.applyDefaultTextControlWidth((Control)this.table);
        this.viewer = new TableViewer(this.table);
        TableUtil.createColumns((Table)this.table, (String[])new String[]{Diagram_Messages.COL_NAME_Id, Diagram_Messages.COL_NAME_Activity, Simulation_Modeling_Messages.PROBABILITY_COLUMN});
        TableUtil.setInitialColumnSizes((Table)this.table, (int[])new int[]{40, 40, 20});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TransitionLabelProvider(this));
        this.viewer.setContentProvider((IContentProvider)new TransitionContentProvider(null));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new TransitionSelectionListener(this));
        this.probabilityPanel = new ProbabilityPanel(composite, 0);
        this.probabilityPanel.setVisible(false);
        this.probabilityPanel.addDragListener((DragListener)new DragListener.Stub(){

            public void onExecute(Coord2D source, int direction) {
                DefaultSimulationGatewayProbabilityPropertyPage.this.updateSelection(DefaultSimulationGatewayProbabilityPropertyPage.this.selectedTransition);
            }

            public void onDragEnd() {
                DefaultSimulationGatewayProbabilityPropertyPage.this.updateSelection(DefaultSimulationGatewayProbabilityPropertyPage.this.selectedTransition);
            }
        });
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 5).numColumns(1).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.probabilityPanel0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.table);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.probabilityPanel);
        return composite;
    }

    public void updateSelection(TransitionConnectionType transitionConnection) {
        if (transitionConnection != null) {
            this.updateSelection(transitionConnection.getTransition());
            this.viewer.update((Object)transitionConnection, null);
        } else {
            this.updateSelection((TransitionType)null);
        }
        this.viewer.refresh();
    }

    protected ProbabilityConfiguration getConfiguration(TransitionType transition) {
        if (!this.configurations.containsKey(transition)) {
            this.configurations.put(transition, this.probabilityPanel.getConfiguration());
        }
        return (ProbabilityConfiguration)this.configurations.get(transition);
    }

    public void updateSelection(TransitionType transition) {
        ProbabilityConfiguration configuration;
        if (this.selectedTransition != null) {
            configuration = this.probabilityPanel.getConfiguration();
            this.configurations.put(this.selectedTransition, configuration);
        }
        this.selectedTransition = transition;
        if (this.selectedTransition != null) {
            configuration = (ProbabilityConfiguration)this.configurations.get(this.selectedTransition);
            this.probabilityPanel.setConfiguration(configuration);
        }
        this.probabilityPanel.setVisible(this.selectedTransition != null);
        this.viewer.refresh();
    }

    public static class TransitionContentProvider
    implements IStructuredContentProvider {
        GatewaySymbol gateway;

        public TransitionContentProvider(GatewaySymbol gateway) {
            this.gateway = gateway;
        }

        public Object[] getElements(Object inputElement) {
            return this.gateway != null ? this.gateway.getOutTransitions().toArray() : new Object[]{};
        }

        public void dispose() {
            this.gateway = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class TransitionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DefaultSimulationGatewayProbabilityPropertyPage owner;

        public TransitionLabelProvider(DefaultSimulationGatewayProbabilityPropertyPage owner) {
            this.owner = owner;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TransitionConnectionType transitionConnection = (TransitionConnectionType)element;
            TransitionType transition = transitionConnection.getTransition();
            if (columnIndex == 0) {
                return transition.getId();
            }
            if (columnIndex == 1) {
                return transitionConnection.getTransition().getTo().getName();
            }
            ProbabilityConfiguration configuration = this.owner.getConfiguration(transition);
            return configuration == null || !configuration.isAnyValue() ? "" : (!configuration.isSimpleValue() ? "curve" : String.valueOf(Long.toString((long)configuration.getValue())) + "%");
        }
    }

    public static class TransitionSelectionListener
    implements ISelectionChangedListener {
        DefaultSimulationGatewayProbabilityPropertyPage owner;

        public TransitionSelectionListener(DefaultSimulationGatewayProbabilityPropertyPage owner) {
            this.owner = owner;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (selection != null && !selection.isEmpty()) {
                TransitionConnectionType transitionConnection = (TransitionConnectionType)selection.getFirstElement();
                this.owner.updateSelection(transitionConnection);
            }
        }
    }
}

