/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.commongui.ScaleTextSynchronizer;
import org.eclipse.stardust.ide.simulation.ui.distributions.BehaviourConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AbstractSimulationPanel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.AdapterForSliderButton;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.StackLayoutComposite;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class BehaviourPanel
extends AbstractSimulationPanel {
    Composite behaviourPanel;
    Text efficiencyRate;
    AdapterForSliderButton efficiencyRateSlider;
    Scale efficiencyRateScale;
    BehaviourConfiguration configuration;

    public BehaviourPanel(Composite parent, int style) {
        super(parent, style);
        this.detailsStackBox = new StackLayoutComposite(this.configPanel, 0);
        this.emptyDetailsPanel = FormBuilder.createComposite((Composite)this.detailsStackBox, (int)1);
        this.behaviourPanel = FormBuilder.createComposite((Composite)this.detailsStackBox, (int)1);
        Composite efficiencyRatePanel = new Composite(this.behaviourPanel, 0);
        Label efficiencyRateLabel = new Label(efficiencyRatePanel, 0);
        efficiencyRateLabel.setText(Simulation_Modeling_Messages.EFFICIENCY_RATE);
        this.efficiencyRate = new Text(efficiencyRatePanel, 133120);
        this.efficiencyRateScale = new Scale(efficiencyRatePanel, 0);
        this.efficiencyRateScale.setMinimum(0);
        this.efficiencyRateScale.setMaximum(100);
        this.efficiencyRateScale.setIncrement(1);
        this.efficiencyRateScale.setPageIncrement(50);
        ScaleTextSynchronizer synchronizer = new ScaleTextSynchronizer(this.efficiencyRateScale, this.efficiencyRate);
        this.efficiencyRateScale.addSelectionListener((SelectionListener)synchronizer);
        this.efficiencyRate.addModifyListener((ModifyListener)synchronizer);
        this.efficiencyRate.addSelectionListener((SelectionListener)synchronizer);
        this.efficiencyRateSlider = new AdapterForSliderButton(efficiencyRatePanel, new AdjustableDoubleRange(Simulation_Modeling_Messages.EFFICIENCY_RATE, 0.0, 100.0, 10.0));
        this.efficiencyRateSlider.addDependentComponent((Control)this.efficiencyRate);
        this.efficiencyRateSlider.addDependentComponent((Control)this.efficiencyRateScale);
        this.detailsStackBox.setTopControl(this.behaviourPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.detailsStackBox);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(this.emptyDetailsPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.behaviourPanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).spacing(0, 5).applyTo(this.behaviourPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)efficiencyRatePanel);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(4).spacing(5, 0).applyTo(efficiencyRatePanel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)efficiencyRateLabel);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(50, -1).applyTo((Control)this.efficiencyRate);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.efficiencyRateScale);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).hint(22, 20).applyTo((Control)this.efficiencyRateSlider.getControl());
    }

    @Override
    protected boolean showAuditCheckBox() {
        return false;
    }

    public BehaviourConfiguration getConfiguration() {
        if (this.configuration != null) {
            this.configuration.getEfficiencyRate().setValue(this.efficiencyRateScale.getSelection());
            this.configuration.getEfficiencyRate().setRange(this.efficiencyRateSlider.getSliderRange());
        }
        return this.configuration;
    }

    public void setConfiguration(BehaviourConfiguration configuration) {
        this.configuration = configuration;
        this.efficiencyRateSlider.setSliderRange(configuration.getEfficiencyRate().getRange());
        this.efficiencyRateScale.setSelection((int)configuration.getEfficiencyRate().getValue());
        this.efficiencyRate.setText(Integer.toString(this.efficiencyRateScale.getSelection()));
        this.detailsStackBox.layout();
    }

    private void setChildrenEnabled(boolean enabled) {
        this.efficiencyRate.setEnabled(enabled);
        this.efficiencyRateSlider.getControl().setEnabled(enabled);
        this.efficiencyRateScale.setEnabled(enabled);
    }
}

