/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.slider.gui;

import org.eclipse.stardust.ide.simulation.ui.SimulationConfigurationList;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractRetrievableSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.AbstractSimulationSubConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.BehaviourConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.DurationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.ProbabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableValue;
import org.eclipse.stardust.ide.simulation.ui.slider.SimSlider;
import org.eclipse.stardust.ide.simulation.ui.slider.SimSliderList;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelTraversalVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;

public class SliderFinder
implements ModelVisitor {
    int configurationId;
    SimulationInterval interval;
    SimSliderList result;

    public SimSlider[] findSlider(ModelType model) {
        this.result = new SimSliderList();
        SimulationConfigurationList list = new SimulationConfigurationList(model);
        if (!list.hasConfigurations()) {
            return new SimSlider[0];
        }
        new ModelTraversalVisitor(this, model);
        return this.result.getAllSlider();
    }

    @Override
    public void visit(ModelType model) {
        SimulationConfigurationList list = new SimulationConfigurationList(model);
        if (!list.hasConfigurations()) {
            return;
        }
        this.interval = list.getCurrentConfiguration().getInterval();
        this.configurationId = list.getCurrentConfigurationId();
    }

    @Override
    public void visit(ProcessDefinitionType element) {
        AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.interval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        this.addSliderIfNotNull((IModelElement)element, this.configurationId, configuration.getBoundValues());
    }

    @Override
    public void visit(ActivityType element) {
        boolean applicationWithDuration;
        ActivityImplementationType implementation = element.getImplementation();
        ApplicationType application = element.getApplication();
        boolean activityWithDuration = implementation != null && (implementation.getValue() == 1 || implementation.getValue() == 0);
        boolean bl = applicationWithDuration = application != null && application.isInteractive();
        if (activityWithDuration || applicationWithDuration) {
            DurationConfiguration configuration = new DurationConfiguration(this.interval);
            configuration.read((IExtensibleElement)element, this.configurationId);
            this.addSliderIfNotNull((IModelElement)element, this.configurationId, configuration.getBoundValues());
        }
    }

    @Override
    public void visit(ApplicationType element) {
        AbstractRetrievableSimulationSubConfiguration configuration = new AvailabilityConfiguration(this.interval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        this.addSliderIfNotNull((IModelElement)element, this.configurationId, configuration.getBoundValues());
        if (!element.isInteractive()) {
            configuration = new DurationConfiguration(this.interval);
            configuration.read((IExtensibleElement)element, this.configurationId);
            this.addSliderIfNotNull((IModelElement)element, this.configurationId, configuration.getBoundValues());
        }
    }

    @Override
    public void visit(IModelParticipant element) {
        AbstractSimulationSubConfiguration configuration = new AvailabilityConfiguration(this.interval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        this.addSliderIfNotNull((IModelElement)element, this.configurationId, configuration.getBoundValues());
        configuration = new BehaviourConfiguration(this.interval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        this.addSliderIfNotNull((IModelElement)element, this.configurationId, configuration.getBoundValues());
    }

    @Override
    public void visit(TransitionType element) {
        ProbabilityConfiguration configuration = new ProbabilityConfiguration(this.interval, SimulationModelUtils.calculateDefaultProbability((IModelElement)element));
        configuration.read((IExtensibleElement)element, this.configurationId);
        this.addSliderIfNotNull((IModelElement)element, this.configurationId, configuration.getBoundValues());
    }

    private void addSliderIfNotNull(IModelElement element, int configurationId, AdjustableValue[] variables) {
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                this.addSliderIfNotNull(element, configurationId, variables[i]);
                ++i;
            }
        }
    }

    private void addSliderIfNotNull(IModelElement element, int configurationId, AdjustableValue variable) {
        if (variable != null && variable.isAdjustable()) {
            this.result.addSlider(variable.createSlider(element, configurationId));
        }
    }

    @Override
    public void visit(DataType element) {
    }
}

