/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;

public class TimeCalculator {
    Calendar c = Calendar.getInstance();

    public TimeCalculator(Calendar c) {
        this.c.setTimeInMillis(c.getTimeInMillis());
    }

    public TimeCalculator(Date d) {
        this.c.setTimeInMillis(d.getTime());
    }

    public TimeCalculator(long l) {
        this.c.setTimeInMillis(l);
    }

    public TimeCalculator(Timestamp t) {
        this.c.setTimeInMillis(t.time);
    }

    public static TimeCalculator now() {
        return new TimeCalculator(Calendar.getInstance());
    }

    public static TimeCalculator fromNow(int field, int amount) {
        return new TimeCalculator(Calendar.getInstance()).add(field, amount);
    }

    public int get(int field) {
        return this.c.get(field);
    }

    public TimeCalculator set(int field, int amount) {
        this.c.add(field, amount);
        return this;
    }

    public TimeCalculator add(int field, int amount) {
        this.c.add(field, amount);
        return this;
    }

    public TimeCalculator moveToBeginOfHour() {
        this.c.set(12, 0);
        this.c.set(13, 0);
        this.c.set(14, 0);
        return this;
    }

    public TimeCalculator moveToBeginOfDay() {
        this.moveToBeginOfHour();
        this.c.set(11, 0);
        return this;
    }

    public TimeCalculator moveToBeginOfWeek() {
        this.moveToBeginOfDay();
        while (this.c.get(7) != 2) {
            this.c.add(6, -1);
        }
        return this;
    }

    public TimeCalculator moveToBeginOfMonth() {
        this.moveToBeginOfDay();
        this.c.set(5, 1);
        return this;
    }

    public TimeCalculator moveToBeginOfYear() {
        this.moveToBeginOfDay();
        this.c.set(6, 1);
        return this;
    }

    public Calendar toCalendar() {
        Calendar r = Calendar.getInstance();
        r.setTimeInMillis(this.c.getTimeInMillis());
        return r;
    }

    public Date toDate() {
        return this.c.getTime();
    }

    public long toLong() {
        return this.c.getTimeInMillis();
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.c.getTimeInMillis());
    }

    public static void main(String[] args) {
        System.out.println(TimeCalculator.now().moveToBeginOfHour().toDate());
        System.out.println(TimeCalculator.now().moveToBeginOfDay().toDate());
        System.out.println(TimeCalculator.now().moveToBeginOfWeek().toDate());
        System.out.println(TimeCalculator.now().moveToBeginOfMonth().toDate());
        System.out.println(TimeCalculator.now().moveToBeginOfYear().toDate());
        System.out.println(TimeCalculator.now().moveToBeginOfDay().toDate());
        System.out.println(TimeCalculator.now().moveToEndOfDay().toDate());
        System.out.println(TimeCalculator.now().add(1, -1).toDate());
    }

    public boolean before(TimeCalculator end) {
        return this.c.before(end.c);
    }

    public boolean after(TimeCalculator end) {
        return this.c.after(end.c);
    }

    public TimeCalculator moveToEndOfHour() {
        this.c.set(12, 59);
        this.c.set(13, 59);
        this.c.set(14, 999);
        return this;
    }

    public TimeCalculator moveToEndOfDay() {
        this.moveToEndOfHour();
        this.c.set(11, 23);
        return this;
    }

    public TimeCalculator moveToEndOfWeek() {
        this.moveToEndOfDay();
        while (this.c.get(7) != 1) {
            this.c.add(6, 1);
        }
        return this;
    }

    public TimeCalculator duplicate() {
        return new TimeCalculator(this.c);
    }
}

