/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.Calendar;
import java.util.Date;

public class Timestamp {
    long time;

    public Timestamp(long timestamp) {
        this.time = timestamp;
    }

    public Timestamp(Timestamp other) {
        this.time = other.time;
    }

    public Timestamp(Long timestamp) {
        this.time = timestamp;
    }

    public Timestamp(Date date) {
        this.time = date.getTime();
    }

    public Timestamp(Calendar calendar) {
        this.time = calendar.getTimeInMillis();
    }

    public Timestamp shiftBackwards(long millis) {
        return new Timestamp(this.time - millis);
    }

    public long getTime() {
        return this.time;
    }

    public Date getDate() {
        return new Date(this.time);
    }

    public Calendar getCalendar() {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(this.time);
        return result;
    }

    public Long getKey() {
        return new Long(this.time);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Timestamp && ((Timestamp)obj).time == this.time;
    }

    public String toString() {
        return new Date(this.time).toString();
    }
}

