/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.ArrayList;
import org.eclipse.stardust.ide.simulation.ui.timeutils.ClassifiedTimestampList;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Interval;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;

public class TimestampHelper {
    public static long toMilisecond(long unitMultiplicator, double value) {
        return Math.round((double)unitMultiplicator * value);
    }

    public static double fromMilisecond(long unitMultiplicator, long milis) {
        return unitMultiplicator > 0L ? (double)milis / (double)unitMultiplicator : 0.0;
    }

    public static Interval[] createGrid(int calendarUnit, long first, long last) {
        if (calendarUnit == 2) {
            return TimestampHelper.createMonthGrid(first, last);
        }
        if (calendarUnit == 3) {
            return TimestampHelper.createWeekGrid(first, last);
        }
        return TimestampHelper.createDayGrid(first, last);
    }

    public static Interval[] createDayGrid(long first, long last) {
        long dayDuration = 86400000L;
        return TimestampHelper.createGrid(dayDuration, first, last);
    }

    public static Interval[] createWeekGrid(long first, long last) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        TimeCalculator tc = new TimeCalculator(first).moveToBeginOfWeek();
        while (tc.toLong() < last) {
            long currentTime = tc.toLong();
            tc.add(3, 1);
            long nextTime = tc.toLong();
            result.add(new Interval(currentTime, nextTime - currentTime));
        }
        return result.toArray(new Interval[result.size()]);
    }

    public static Interval[] createMonthGrid(long first, long last) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        TimeCalculator tc = new TimeCalculator(first).moveToBeginOfMonth();
        while (tc.toLong() < last) {
            long currentTime = tc.toLong();
            tc.add(2, 1);
            long nextTime = tc.toLong();
            result.add(new Interval(currentTime, nextTime - currentTime));
        }
        return result.toArray(new Interval[result.size()]);
    }

    public static Interval[] createGrid(long millis, long first, long last) {
        long startIndex = first / millis;
        long endIndex = last / millis + 1L;
        Interval[] result = new Interval[(int)(endIndex - startIndex)];
        int i = 0;
        while (i < result.length) {
            result[i] = new Interval(first + (long)i * millis, millis);
            ++i;
        }
        return result;
    }

    public static TimestampValue[] gridToTimestampValueArray(Interval[] grid) {
        TimestampValue[] result = new TimestampValue[grid.length + 1];
        int i = 0;
        while (i < grid.length) {
            result[i] = new TimestampValue(grid[i].getStartTimestamp(), 0.0);
            ++i;
        }
        result[grid.length] = new TimestampValue(grid[grid.length - 1].getEndTimestamp(), 0.0);
        return result;
    }

    public static ClassifiedTimestampList[] gridToClassifiedTimestampList(Interval[] grid) {
        ClassifiedTimestampList[] result = new ClassifiedTimestampList[grid.length];
        int i = 0;
        while (i < grid.length) {
            result[i] = new ClassifiedTimestampList(grid[i]);
            ++i;
        }
        return result;
    }
}

