/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.timeutils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.timeutils.Timestamp;

public class TimestampList {
    List impl = new ArrayList();

    public Timestamp get(int index) {
        return (Timestamp)this.impl.get(index);
    }

    public Timestamp getFirst() {
        return (Timestamp)this.impl.get(0);
    }

    public Timestamp getLast() {
        return (Timestamp)this.impl.get(this.impl.size() - 1);
    }

    public void add(Timestamp t) {
        this.impl.add(t);
    }

    public void addAll(TimestampList list) {
        this.impl.addAll(list.impl);
    }

    public void remove(Timestamp t) {
        this.impl.remove(t);
    }

    public int size() {
        return this.impl.size();
    }

    public double averageTime(int offset, int length) {
        double sum = 0.0;
        int n = offset;
        while (n < offset + length) {
            sum += (double)this.get((int)n).time;
            ++n;
        }
        return sum / (double)length;
    }

    public double averageTime() {
        return this.averageTime(0, this.size());
    }

    public double averageTimeWithCutOut() {
        double totalResult = 0.0;
        int offset = 0;
        while (offset < this.size()) {
            int blockSize = Math.min(this.size() - offset, 50000);
            double subResult = this.averageTime(offset, blockSize);
            totalResult = ((double)offset * totalResult + (double)blockSize * subResult) / (double)(offset + blockSize);
            offset += 50000;
        }
        return totalResult;
    }

    public Timestamp minTime() {
        long result = this.get((int)0).time;
        int n = 1;
        while (n < this.size()) {
            result = Math.min(result, this.get((int)n).time);
            ++n;
        }
        return new Timestamp(result);
    }

    public Timestamp maxTime() {
        long result = this.get((int)0).time;
        int n = 1;
        while (n < this.size()) {
            result = Math.max(result, this.get((int)n).time);
            ++n;
        }
        return new Timestamp(result);
    }
}

